/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.model;

import java.util.List;
import java.util.stream.Stream;
import org.rcsb.cif.SchemaMismatchException;
import org.rcsb.cif.model.Block;
import org.rcsb.cif.model.CifFileBuilder;
import org.rcsb.cif.schema.SchemaProvider;

public interface CifFile {
    public List<? extends Block> getBlocks();

    default public Stream<? extends Block> blocks() {
        return this.getBlocks().stream();
    }

    default public <F extends CifFile, B extends CifFileBuilder> F as(SchemaProvider<F, B> schemaProvider) throws SchemaMismatchException {
        schemaProvider.validate(this);
        return this.asButWithoutValidation(schemaProvider);
    }

    default public <F extends CifFile, B extends CifFileBuilder> F asButWithoutValidation(SchemaProvider<F, B> schemaProvider) throws SchemaMismatchException {
        return schemaProvider.createTypedFile(this);
    }
}

