/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.model;

import java.util.List;
import java.util.Map;
import org.rcsb.cif.model.BlockBuilder;
import org.rcsb.cif.model.Category;
import org.rcsb.cif.model.CifFileBuilder;
import org.rcsb.cif.model.Column;
import org.rcsb.cif.model.ColumnBuilder;
import org.rcsb.cif.model.FloatColumn;
import org.rcsb.cif.model.FloatColumnBuilder;
import org.rcsb.cif.model.IntColumn;
import org.rcsb.cif.model.IntColumnBuilder;
import org.rcsb.cif.model.StrColumnBuilder;
import org.rcsb.cif.model.ValueKind;
import org.rcsb.cif.model.text.TextColumn;
import org.rcsb.cif.schema.DelegatingFloatColumn;
import org.rcsb.cif.schema.DelegatingIntColumn;
import org.rcsb.cif.schema.DelegatingStrColumn;

public interface CategoryBuilder<P extends BlockBuilder<PP>, PP extends CifFileBuilder> {
    public String getCategoryName();

    public Map<String, Column<?>> getColumns();

    public P leaveCategory();

    public Category build();

    public CategoryBuilder<P, PP> addColumn(Column<?> var1);

    public void digest(IntColumnBuilder<? extends CategoryBuilder<P, PP>, P, PP> var1);

    public void digest(FloatColumnBuilder<? extends CategoryBuilder<P, PP>, P, PP> var1);

    public void digest(StrColumnBuilder<? extends CategoryBuilder<P, PP>, P, PP> var1);

    public IntColumnBuilder<CategoryBuilder<P, PP>, P, PP> enterIntColumn(String var1);

    public FloatColumnBuilder<CategoryBuilder<P, PP>, P, PP> enterFloatColumn(String var1);

    public StrColumnBuilder<CategoryBuilder<P, PP>, P, PP> enterStrColumn(String var1);

    public void registerChild(ColumnBuilder<? extends CategoryBuilder<P, PP>, P, PP> var1);

    public static <C extends Column<?>> C createColumnText(String columnName, List<?> values, List<ValueKind> mask, Class<C> hint) {
        int length = values.size();
        int[] startToken = new int[length];
        int[] endToken = new int[length];
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            startToken[i] = builder.length();
            String value = String.valueOf(values.get(i));
            if (mask.get(i) == ValueKind.NOT_PRESENT) {
                value = ".";
            } else if (mask.get(i) == ValueKind.UNKNOWN) {
                value = "?";
            }
            builder.append(value);
            endToken[i] = builder.length();
        }
        String data = builder.toString();
        int rowCount = startToken.length;
        TextColumn column = new TextColumn(columnName, rowCount, data, startToken, endToken);
        if (hint.equals(IntColumn.class)) {
            return (C)new DelegatingIntColumn(column);
        }
        if (hint.equals(FloatColumn.class)) {
            return (C)new DelegatingFloatColumn(column);
        }
        return (C)new DelegatingStrColumn(column);
    }
}

