/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary.encoding;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;
import org.rcsb.cif.binary.data.Float32Array;
import org.rcsb.cif.binary.data.Float64Array;
import org.rcsb.cif.binary.data.FloatArray;
import org.rcsb.cif.binary.data.Int32Array;
import org.rcsb.cif.binary.encoding.Encoding;

public class IntervalQuantizationEncoding
implements Encoding<FloatArray, Int32Array> {
    private int min;
    private int max;
    private int numSteps;
    private int srcType;

    public IntervalQuantizationEncoding() {
    }

    public IntervalQuantizationEncoding(int min, int max, int numSteps, int srcType) {
        this.min = min;
        this.max = max;
        this.numSteps = numSteps;
        this.srcType = srcType;
    }

    @Override
    public Map<String, Object> getMapRepresentation() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("kind", "IntervalQuantization");
        map.put("min", this.min);
        map.put("max", this.max);
        map.put("numSteps", this.numSteps);
        map.put("srcType", this.srcType);
        return map;
    }

    @Override
    public FloatArray decode(Int32Array data) {
        double delta = (double)(this.max - this.min) / ((double)this.numSteps - 1.0);
        int[] intData = data.getData();
        double[] output = new double[intData.length];
        for (int i = 0; i < intData.length; ++i) {
            output[i] = (double)this.min + delta * (double)intData[i];
        }
        return this.srcType == 32 ? new Float32Array(output, data.getEncoding()) : new Float64Array(output, data.getEncoding());
    }

    @Override
    public Int32Array encode(FloatArray data) {
        double[] input = data.getData();
        this.srcType = data.getType();
        if (input.length == 0) {
            ArrayDeque enc = new ArrayDeque(data.getEncoding());
            this.srcType = 3;
            enc.add(this);
            return new Int32Array(new int[0], (Deque<Encoding<?, ?>>)enc);
        }
        if (this.max < this.min) {
            int t = this.min;
            this.min = this.max;
            this.max = t;
        }
        double delta = (double)(this.max - this.min) / ((double)this.numSteps - 1.0);
        int[] output = new int[input.length];
        for (int i = 0; i < input.length; ++i) {
            double v = input[i];
            output[i] = v <= (double)this.min ? 0 : (v >= (double)this.max ? this.numSteps - 1 : (delta == 0.0 ? 0 : (int)Math.round((v - (double)this.min) / delta)));
        }
        ArrayDeque enc = new ArrayDeque(data.getEncoding());
        enc.add(this);
        return new Int32Array(output, (Deque<Encoding<?, ?>>)enc);
    }

    public String toString() {
        return "IntervalQuantizationEncoding{min=" + this.min + ", max=" + this.max + ", numSteps=" + this.numSteps + ", srcType=" + this.srcType + "}";
    }
}

