/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary.encoding;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.IntStream;
import org.rcsb.cif.EncodingException;
import org.rcsb.cif.binary.data.AbstractEncodedData;
import org.rcsb.cif.binary.data.Int16Array;
import org.rcsb.cif.binary.data.Int32Array;
import org.rcsb.cif.binary.data.Int8Array;
import org.rcsb.cif.binary.data.IntArray;
import org.rcsb.cif.binary.data.Uint16Array;
import org.rcsb.cif.binary.data.Uint8Array;
import org.rcsb.cif.binary.encoding.Encoding;

public class IntegerPackingEncoding
implements Encoding<Int32Array, IntArray> {
    private int byteCount;
    private boolean isUnsigned;
    private int srcSize;

    public IntegerPackingEncoding() {
    }

    public IntegerPackingEncoding(int byteCount, boolean isUnsigned, int srcSize) {
        this.byteCount = byteCount;
        this.isUnsigned = isUnsigned;
        this.srcSize = srcSize;
    }

    @Override
    public Map<String, Object> getMapRepresentation() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("kind", "IntegerPacking");
        map.put("byteCount", this.byteCount);
        map.put("isUnsigned", this.isUnsigned);
        map.put("srcSize", this.srcSize);
        return map;
    }

    @Override
    public Int32Array decode(IntArray data) {
        int upperLimit;
        int[] input = data.getData();
        boolean unsigned = this.isUnsigned;
        if (input.length == this.srcSize && this.byteCount == 4) {
            Int32Array output = new Int32Array(input, data.getEncoding());
            output.setEncoding((Deque)data.getEncoding());
            return output;
        }
        int lowerLimit = 0;
        if (unsigned) {
            upperLimit = this.byteCount == 1 ? 255 : 65535;
        } else {
            upperLimit = this.byteCount == 1 ? 127 : Short.MAX_VALUE;
            lowerLimit = -upperLimit - 1;
        }
        int n = input.length;
        int[] output = new int[this.srcSize];
        int i = 0;
        int j = 0;
        while (i < n) {
            int value = 0;
            int t = input[i];
            while (unsigned ? t == upperLimit : t == upperLimit || t == lowerLimit) {
                value += t;
                t = input[++i];
            }
            output[j] = value += t;
            ++i;
            ++j;
        }
        return new Int32Array(output, data.getEncoding());
    }

    @Override
    public IntArray encode(Int32Array data) {
        int[] input = data.getData();
        Packing packing = this.determinePacking(input);
        if (packing.bytesPerElement == 4) {
            ArrayDeque enc = new ArrayDeque(data.getEncoding());
            return new Int32Array(input, (Deque<Encoding<?, ?>>)enc);
        }
        int upperLimit = packing.signed ? (packing.bytesPerElement == 1 ? 127 : Short.MAX_VALUE) : (packing.bytesPerElement == 1 ? 255 : 65535);
        int lowerLimit = -upperLimit - 1;
        if (packing.size > Integer.MAX_VALUE) {
            throw new EncodingException("too much data - cannot allocate array large enough to encode " + data.length() + " elements");
        }
        int[] outputArray = new int[(int)packing.size];
        int j = 0;
        for (int i1 : input) {
            int value = i1;
            if (value >= 0) {
                while (value >= upperLimit) {
                    outputArray[j] = upperLimit;
                    ++j;
                    value -= upperLimit;
                }
            } else {
                while (value <= lowerLimit) {
                    outputArray[j] = lowerLimit;
                    ++j;
                    value -= lowerLimit;
                }
            }
            outputArray[j] = value;
            ++j;
        }
        AbstractEncodedData output = packing.signed ? (packing.bytesPerElement == 1 ? new Int8Array(outputArray) : new Int16Array(outputArray)) : (packing.bytesPerElement == 1 ? new Uint8Array(outputArray) : new Uint16Array(outputArray));
        ArrayDeque enc = new ArrayDeque(data.getEncoding());
        this.byteCount = packing.bytesPerElement;
        this.isUnsigned = !packing.signed;
        this.srcSize = data.length();
        enc.add(this);
        output.setEncoding(enc);
        return output;
    }

    private Packing determinePacking(int[] input) {
        boolean signed = IntStream.of(input).anyMatch(i -> i < 0);
        long size8 = this.packingSize(input, signed ? 127 : 255);
        long size16 = this.packingSize(input, signed ? Short.MAX_VALUE : 65535);
        if ((long)input.length * 4L < size16 * 2L) {
            return new Packing(signed, input.length, 4);
        }
        if (size16 * 2L < size8) {
            return new Packing(signed, size16, 2);
        }
        return new Packing(signed, size8, 1);
    }

    private long packingSize(int[] input, int upperLimit) {
        int lowerLimit = -upperLimit - 1;
        long size = 0L;
        for (int value : input) {
            if (value == 0) {
                ++size;
                continue;
            }
            if (value > 0) {
                size = (long)((double)size + Math.ceil((double)value / (double)upperLimit));
                if (value % upperLimit != 0) continue;
                ++size;
                continue;
            }
            size = (long)((double)size + Math.ceil((double)value / (double)lowerLimit));
            if (value % lowerLimit != 0) continue;
            ++size;
        }
        if (size < 0L) {
            return Long.MAX_VALUE;
        }
        return size;
    }

    public String toString() {
        return "IntegerPackingEncoding{byteCount=" + this.byteCount + ", isUnsigned=" + this.isUnsigned + ", srcSize=" + this.srcSize + "}";
    }

    static class Packing {
        final boolean signed;
        final long size;
        final int bytesPerElement;

        Packing(boolean signed, long size, int bytesPerElement) {
            this.signed = signed;
            this.size = size;
            this.bytesPerElement = bytesPerElement;
        }
    }
}

