/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary.encoding;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;
import org.rcsb.cif.binary.data.Float32Array;
import org.rcsb.cif.binary.data.Float64Array;
import org.rcsb.cif.binary.data.FloatArray;
import org.rcsb.cif.binary.data.Int32Array;
import org.rcsb.cif.binary.encoding.Encoding;

public class FixedPointEncoding
implements Encoding<FloatArray, Int32Array> {
    private final int factor;
    private int srcType;

    public FixedPointEncoding(int factor) {
        this.factor = factor;
    }

    public FixedPointEncoding(int factor, int srcType) {
        this.factor = factor;
        this.srcType = srcType;
    }

    @Override
    public Map<String, Object> getMapRepresentation() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("kind", "FixedPoint");
        map.put("factor", this.factor);
        map.put("srcType", this.srcType);
        return map;
    }

    @Override
    public FloatArray decode(Int32Array data) {
        double f = 1.0 / (double)this.factor;
        int[] intData = data.getData();
        double[] outputArray = new double[intData.length];
        for (int i = 0; i < intData.length; ++i) {
            outputArray[i] = (double)intData[i] * f;
        }
        return this.srcType == 32 ? new Float32Array(outputArray, data.getEncoding()) : new Float64Array(outputArray, data.getEncoding());
    }

    @Override
    public Int32Array encode(FloatArray data) {
        this.srcType = data.getType();
        double[] floatData = data.getData();
        int[] outputArray = new int[floatData.length];
        for (int i = 0; i < floatData.length; ++i) {
            outputArray[i] = (int)Math.round(floatData[i] * (double)this.factor);
        }
        ArrayDeque enc = new ArrayDeque(data.getEncoding());
        enc.add(this);
        return new Int32Array(outputArray, (Deque<Encoding<?, ?>>)enc);
    }

    public String toString() {
        return "FixedPointEncoding{factor=" + this.factor + ", srcType=" + this.srcType + "}";
    }
}

