/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.binary.codec;

import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import org.rcsb.cif.binary.data.ByteArray;
import org.rcsb.cif.binary.data.EncodedData;
import org.rcsb.cif.binary.encoding.ByteArrayEncoding;
import org.rcsb.cif.binary.encoding.DeltaEncoding;
import org.rcsb.cif.binary.encoding.Encoding;
import org.rcsb.cif.binary.encoding.FixedPointEncoding;
import org.rcsb.cif.binary.encoding.IntegerPackingEncoding;
import org.rcsb.cif.binary.encoding.IntervalQuantizationEncoding;
import org.rcsb.cif.binary.encoding.RunLengthEncoding;
import org.rcsb.cif.binary.encoding.StringArrayEncoding;

public class BinaryCifCodec {
    public static final String CODEC_NAME = "ciftools-java";
    public static final String VERSION = "0.3.0";
    public static final String MIN_VERSION = "0.3";
    public static final boolean IS_NATIVE_LITTLE_ENDIAN = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);

    private BinaryCifCodec() {
    }

    public static EncodedData<?> decode(EncodedData<?> data) {
        EncodedData<?> current = data;
        while (current.hasNextDecodingStep()) {
            Encoding<?, ?> encoding = current.getEncoding().removeLast();
            current = encoding.decode(current);
        }
        return current;
    }

    public static Object decode(Map<String, Object> encodedData) {
        ByteArray current = new ByteArray((byte[])encodedData.get("data"));
        Object[] encodingMaps = (Object[])encodedData.get("encoding");
        for (int i = encodingMaps.length - 1; i >= 0; --i) {
            Map map = (Map)encodingMaps[i];
            Encoding<?, ?> encoding = BinaryCifCodec.deserializeEncodingMap(map);
            current = encoding.decode(current);
        }
        return current.getData();
    }

    private static Encoding<?, ?> deserializeEncodingMap(Map<String, Object> encoding) {
        String kind;
        switch (kind = (String)encoding.get("kind")) {
            case "ByteArray": {
                int type = (Integer)encoding.get("type");
                switch (type) {
                    case 1: {
                        return ByteArrayEncoding.INT8;
                    }
                    case 2: {
                        return ByteArrayEncoding.INT16;
                    }
                    case 3: {
                        return ByteArrayEncoding.INT32;
                    }
                    case 4: {
                        return ByteArrayEncoding.UINT8;
                    }
                    case 5: {
                        return ByteArrayEncoding.UINT16;
                    }
                    case 6: {
                        return ByteArrayEncoding.UINT32;
                    }
                    case 32: {
                        return ByteArrayEncoding.FLOAT32;
                    }
                    case 33: {
                        return ByteArrayEncoding.FLOAT64;
                    }
                }
                throw new UnsupportedOperationException("cannot handle byte array encoding type " + type);
            }
            case "FixedPoint": {
                int factor = (Integer)encoding.get("factor");
                int srcType = (Integer)encoding.get("srcType");
                return new FixedPointEncoding(factor, srcType);
            }
            case "IntervalQuantization": {
                int min = (Integer)encoding.get("min");
                int max = (Integer)encoding.get("max");
                int numSteps = (Integer)encoding.get("numSteps");
                int srcType = (Integer)encoding.get("srcType");
                return new IntervalQuantizationEncoding(min, max, numSteps, srcType);
            }
            case "RunLength": {
                int srcType = (Integer)encoding.get("srcType");
                int srcSize = (Integer)encoding.get("srcSize");
                return new RunLengthEncoding(srcType, srcSize);
            }
            case "Delta": {
                int origin = (Integer)encoding.get("origin");
                int srcType = (Integer)encoding.get("srcType");
                return new DeltaEncoding(origin, srcType);
            }
            case "IntegerPacking": {
                int byteCount = (Integer)encoding.get("byteCount");
                boolean isUnsigned = (Boolean)encoding.get("isUnsigned");
                int srcSize = (Integer)encoding.get("srcSize");
                return new IntegerPackingEncoding(byteCount, isUnsigned, srcSize);
            }
            case "StringArray": {
                String stringData = (String)encoding.get("stringData");
                byte[] offsets = (byte[])encoding.get("offsets");
                Deque<Encoding<?, ?>> outputEncoding = BinaryCifCodec.deserializeEncodingDeque(encoding.get("dataEncoding"));
                Deque<Encoding<?, ?>> offsetEncoding = BinaryCifCodec.deserializeEncodingDeque(encoding.get("offsetEncoding"));
                return new StringArrayEncoding(stringData, offsets, outputEncoding, offsetEncoding);
            }
        }
        throw new IllegalArgumentException("Unsupported Encoding kind: " + kind);
    }

    private static Deque<Encoding<?, ?>> deserializeEncodingDeque(Object encoding) {
        Object[] encodingArray = (Object[])encoding;
        ArrayDeque encodings = new ArrayDeque();
        for (Object o : encodingArray) {
            encodings.add(BinaryCifCodec.deserializeEncodingMap((Map)o));
        }
        return encodings;
    }
}

