/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.util;

import edu.rit.util.TimerTask;
import edu.rit.util.TimerThread;
import java.util.Date;

public class Timer {
    private TimerThread myTimerThread;
    private TimerTask myTimerTask;
    private int myState = 0;
    private static final int STOPPED = 0;
    private static final int STARTED = 1;
    private static final int TRIGGERED = 2;
    private int myKind;
    private static final int ONE_SHOT_TIMEOUT = 0;
    private static final int FIXED_RATE_TIMEOUT = 1;
    private static final int FIXED_INTERVAL_TIMEOUT = 2;
    private long myTimeout;
    private long myInterval;

    Timer(TimerThread theTimerThread, TimerTask theTimerTask) {
        if (theTimerTask == null) {
            throw new NullPointerException();
        }
        this.myTimerThread = theTimerThread;
        this.myTimerTask = theTimerTask;
    }

    public synchronized void start(Date theTime) {
        this.myState = 1;
        this.myKind = 0;
        this.myTimeout = theTime.getTime();
        this.myTimerThread.schedule(this.myTimeout, this);
    }

    public synchronized void start(long theInterval) {
        this.myState = 1;
        this.myKind = 0;
        this.myTimeout = System.currentTimeMillis() + theInterval;
        this.myTimerThread.schedule(this.myTimeout, this);
    }

    public synchronized void start(Date theFirstTime, long theRepetitionInterval) {
        if (theRepetitionInterval <= 0L) {
            throw new IllegalArgumentException();
        }
        this.myState = 1;
        this.myKind = 1;
        this.myTimeout = theFirstTime.getTime();
        this.myInterval = theRepetitionInterval;
        this.myTimerThread.schedule(this.myTimeout, this);
    }

    public synchronized void start(long theFirstInterval, long theRepetitionInterval) {
        if (theRepetitionInterval <= 0L) {
            throw new IllegalArgumentException();
        }
        this.myState = 1;
        this.myKind = 1;
        this.myTimeout = System.currentTimeMillis() + theFirstInterval;
        this.myInterval = theRepetitionInterval;
        this.myTimerThread.schedule(this.myTimeout, this);
    }

    public synchronized void startFixedIntervalTimeout(Date theFirstTime, long theRepetitionInterval) {
        if (theRepetitionInterval <= 0L) {
            throw new IllegalArgumentException();
        }
        this.myState = 1;
        this.myKind = 2;
        this.myTimeout = theFirstTime.getTime();
        this.myInterval = theRepetitionInterval;
        this.myTimerThread.schedule(this.myTimeout, this);
    }

    public synchronized void startFixedIntervalTimeout(long theFirstInterval, long theRepetitionInterval) {
        if (theRepetitionInterval <= 0L) {
            throw new IllegalArgumentException();
        }
        this.myState = 1;
        this.myKind = 2;
        this.myTimeout = System.currentTimeMillis() + theFirstInterval;
        this.myInterval = theRepetitionInterval;
        this.myTimerThread.schedule(this.myTimeout, this);
    }

    public synchronized void stop() {
        this.myState = 0;
    }

    public synchronized boolean isStopped() {
        return this.myState == 0;
    }

    public synchronized boolean isStarted() {
        return this.myState == 1;
    }

    public synchronized boolean isTriggered() {
        return this.myState == 2;
    }

    public synchronized long getTimeout() {
        return this.myState == 0 ? Long.MAX_VALUE : this.myTimeout;
    }

    public TimerTask getTimerTask() {
        return this.myTimerTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void trigger(long theTriggerTime) {
        Timer timer = this;
        synchronized (timer) {
            if (this.myState != 1 || this.myTimeout > theTriggerTime) {
                return;
            }
            this.myState = 2;
        }
        this.myTimerTask.action(this);
        timer = this;
        synchronized (timer) {
            if (this.myState == 2) {
                if (this.myKind == 1) {
                    this.myState = 1;
                    this.myTimeout += this.myInterval;
                    this.myTimerThread.schedule(this.myTimeout, this);
                } else if (this.myKind == 2) {
                    this.myState = 1;
                    this.myTimeout = System.currentTimeMillis() + this.myInterval;
                    this.myTimerThread.schedule(this.myTimeout, this);
                } else {
                    this.myState = 0;
                }
            }
        }
    }
}

