/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.util;

import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;

public class ByteSequence {
    private final LinkedList<byte[]> myChunkList = new LinkedList();
    private final LinkedList<Integer> myLengthList = new LinkedList();
    private int myTotalLength;

    public ByteSequence(byte[] buf) {
        this(buf, 0, buf.length);
    }

    public ByteSequence(byte[] buf, int off, int len) {
        if (off < 0 || len < 0 || off + len > buf.length) {
            throw new IndexOutOfBoundsException();
        }
        byte[] chunk = new byte[len];
        System.arraycopy(buf, off, chunk, 0, len);
        this.myChunkList.add(chunk);
        this.myLengthList.add(len);
        this.myTotalLength = len;
    }

    public ByteSequence(InputStream theInputStream) throws IOException {
        if (theInputStream != null) {
            byte[] chunk;
            int length;
            while ((length = theInputStream.read(chunk = new byte[4096])) != -1) {
                this.myChunkList.add(chunk);
                this.myLengthList.add(length);
                this.myTotalLength += length;
                if (this.myTotalLength >= 0) continue;
                throw new IOException("ByteSequence(): Input stream too long");
            }
            theInputStream.close();
        }
    }

    public ByteSequence(ByteSequence theByteSequence) {
        byte[] chunk = theByteSequence.toByteArray();
        this.myChunkList.add(chunk);
        this.myLengthList.add(chunk.length);
        this.myTotalLength = chunk.length;
    }

    public int length() {
        return this.myTotalLength;
    }

    public byte[] toByteArray() {
        byte[] result = new byte[this.myTotalLength];
        this.copy(result);
        return result;
    }

    public int copy(byte[] buf) {
        return this.copy(buf, 0, buf.length);
    }

    public int copy(byte[] buf, int off, int len) {
        if (off < 0 || len < 0 || off + len > buf.length) {
            throw new IndexOutOfBoundsException();
        }
        int total = 0;
        Iterator chunkiter = this.myChunkList.iterator();
        Iterator lengthiter = this.myLengthList.iterator();
        while (len > 0 && chunkiter.hasNext()) {
            byte[] chunk = (byte[])chunkiter.next();
            int length = (Integer)lengthiter.next();
            int n = Math.min(length, len);
            System.arraycopy(chunk, 0, buf, off, n);
            off += n;
            len -= n;
            total += n;
        }
        return total;
    }

    public void write(OutputStream theOutputStream) throws IOException {
        Iterator chunkiter = this.myChunkList.iterator();
        Iterator lengthiter = this.myLengthList.iterator();
        while (chunkiter.hasNext()) {
            byte[] chunk = (byte[])chunkiter.next();
            int length = (Integer)lengthiter.next();
            theOutputStream.write(chunk, 0, length);
        }
    }

    public void write(DataOutput theOutputStream) throws IOException {
        Iterator chunkiter = this.myChunkList.iterator();
        Iterator lengthiter = this.myLengthList.iterator();
        while (chunkiter.hasNext()) {
            byte[] chunk = (byte[])chunkiter.next();
            int length = (Integer)lengthiter.next();
            theOutputStream.write(chunk, 0, length);
        }
    }
}

