/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.util;

import edu.rit.util.Range;
import java.lang.reflect.Array;

public class Arrays {
    private Arrays() {
    }

    public static <T, ST extends T> void allocate(T[] array, Class<ST> type) throws InstantiationException, IllegalAccessException {
        Arrays.allocate(array, new Range(0, array.length - 1), type);
    }

    public static <T, ST extends T> void allocate(T[] array, Range range, Class<ST> type) throws InstantiationException, IllegalAccessException {
        int lb = range.lb();
        int ub = range.ub();
        int stride = range.stride();
        if (0 > lb || ub >= array.length) {
            throw new IndexOutOfBoundsException("Arrays.allocate(): array indexes = 0.." + (array.length - 1) + ", range = " + String.valueOf(range));
        }
        for (int i = lb; i <= ub; i += stride) {
            array[i] = type.newInstance();
        }
    }

    public static void allocate(boolean[][] matrix, int ncols) {
        Arrays.allocate(matrix, new Range(0, matrix.length - 1), ncols);
    }

    public static void allocate(boolean[][] matrix, Range rowRange, int ncols) {
        int rowLb = rowRange.lb();
        int rowUb = rowRange.ub();
        int rowStride = rowRange.stride();
        if (0 > rowLb || rowUb >= matrix.length) {
            throw new IndexOutOfBoundsException("Arrays.allocate(): matrix row indexes = 0.." + (matrix.length - 1) + ", row range = " + String.valueOf(rowRange));
        }
        for (int i = rowLb; i <= rowUb; i += rowStride) {
            matrix[i] = new boolean[ncols];
        }
    }

    public static void allocate(byte[][] matrix, int ncols) {
        Arrays.allocate(matrix, new Range(0, matrix.length - 1), ncols);
    }

    public static void allocate(byte[][] matrix, Range rowRange, int ncols) {
        int rowLb = rowRange.lb();
        int rowUb = rowRange.ub();
        int rowStride = rowRange.stride();
        if (0 > rowLb || rowUb >= matrix.length) {
            throw new IndexOutOfBoundsException("Arrays.allocate(): matrix row indexes = 0.." + (matrix.length - 1) + ", row range = " + String.valueOf(rowRange));
        }
        for (int i = rowLb; i <= rowUb; i += rowStride) {
            matrix[i] = new byte[ncols];
        }
    }

    public static void allocate(char[][] matrix, int ncols) {
        Arrays.allocate(matrix, new Range(0, matrix.length - 1), ncols);
    }

    public static void allocate(char[][] matrix, Range rowRange, int ncols) {
        int rowLb = rowRange.lb();
        int rowUb = rowRange.ub();
        int rowStride = rowRange.stride();
        if (0 > rowLb || rowUb >= matrix.length) {
            throw new IndexOutOfBoundsException("Arrays.allocate(): matrix row indexes = 0.." + (matrix.length - 1) + ", row range = " + String.valueOf(rowRange));
        }
        for (int i = rowLb; i <= rowUb; i += rowStride) {
            matrix[i] = new char[ncols];
        }
    }

    public static void allocate(double[][] matrix, int ncols) {
        Arrays.allocate(matrix, new Range(0, matrix.length - 1), ncols);
    }

    public static void allocate(double[][] matrix, Range rowRange, int ncols) {
        int rowLb = rowRange.lb();
        int rowUb = rowRange.ub();
        int rowStride = rowRange.stride();
        if (0 > rowLb || rowUb >= matrix.length) {
            throw new IndexOutOfBoundsException("Arrays.allocate(): matrix row indexes = 0.." + (matrix.length - 1) + ", row range = " + String.valueOf(rowRange));
        }
        for (int i = rowLb; i <= rowUb; i += rowStride) {
            matrix[i] = new double[ncols];
        }
    }

    public static void allocate(float[][] matrix, int ncols) {
        Arrays.allocate(matrix, new Range(0, matrix.length - 1), ncols);
    }

    public static void allocate(float[][] matrix, Range rowRange, int ncols) {
        int rowLb = rowRange.lb();
        int rowUb = rowRange.ub();
        int rowStride = rowRange.stride();
        if (0 > rowLb || rowUb >= matrix.length) {
            throw new IndexOutOfBoundsException("Arrays.allocate(): matrix row indexes = 0.." + (matrix.length - 1) + ", row range = " + String.valueOf(rowRange));
        }
        for (int i = rowLb; i <= rowUb; i += rowStride) {
            matrix[i] = new float[ncols];
        }
    }

    public static void allocate(int[][] matrix, int ncols) {
        Arrays.allocate(matrix, new Range(0, matrix.length - 1), ncols);
    }

    public static void allocate(int[][] matrix, Range rowRange, int ncols) {
        int rowLb = rowRange.lb();
        int rowUb = rowRange.ub();
        int rowStride = rowRange.stride();
        if (0 > rowLb || rowUb >= matrix.length) {
            throw new IndexOutOfBoundsException("Arrays.allocate(): matrix row indexes = 0.." + (matrix.length - 1) + ", row range = " + String.valueOf(rowRange));
        }
        for (int i = rowLb; i <= rowUb; i += rowStride) {
            matrix[i] = new int[ncols];
        }
    }

    public static void allocate(long[][] matrix, int ncols) {
        Arrays.allocate(matrix, new Range(0, matrix.length - 1), ncols);
    }

    public static void allocate(long[][] matrix, Range rowRange, int ncols) {
        int rowLb = rowRange.lb();
        int rowUb = rowRange.ub();
        int rowStride = rowRange.stride();
        if (0 > rowLb || rowUb >= matrix.length) {
            throw new IndexOutOfBoundsException("Arrays.allocate(): matrix row indexes = 0.." + (matrix.length - 1) + ", row range = " + String.valueOf(rowRange));
        }
        for (int i = rowLb; i <= rowUb; i += rowStride) {
            matrix[i] = new long[ncols];
        }
    }

    public static void allocate(short[][] matrix, int ncols) {
        Arrays.allocate(matrix, new Range(0, matrix.length - 1), ncols);
    }

    public static void allocate(short[][] matrix, Range rowRange, int ncols) {
        int rowLb = rowRange.lb();
        int rowUb = rowRange.ub();
        int rowStride = rowRange.stride();
        if (0 > rowLb || rowUb >= matrix.length) {
            throw new IndexOutOfBoundsException("Arrays.allocate(): matrix row indexes = 0.." + (matrix.length - 1) + ", row range = " + String.valueOf(rowRange));
        }
        for (int i = rowLb; i <= rowUb; i += rowStride) {
            matrix[i] = new short[ncols];
        }
    }

    public static <T, ST extends T> void allocate(T[][] matrix, int ncols, Class<ST> type) throws InstantiationException, IllegalAccessException {
        Arrays.allocate(matrix, new Range(0, matrix.length - 1), ncols, new Range(0, ncols - 1), type);
    }

    public static <T, ST extends T> void allocate(T[][] matrix, Range rowRange, int ncols, Class<ST> type) throws InstantiationException, IllegalAccessException {
        Arrays.allocate(matrix, rowRange, ncols, new Range(0, ncols - 1), type);
    }

    public static <T, ST extends T> void allocate(T[][] matrix, Range rowRange, int ncols, Range colRange, Class<ST> type) throws InstantiationException, IllegalAccessException {
        int rowLb = rowRange.lb();
        int rowUb = rowRange.ub();
        int rowStride = rowRange.stride();
        if (0 > rowLb || rowUb >= matrix.length) {
            throw new IndexOutOfBoundsException("Arrays.allocate(): matrix row indexes = 0.." + (matrix.length - 1) + ", row range = " + String.valueOf(rowRange));
        }
        int colLb = colRange.lb();
        int colUb = colRange.ub();
        int colStride = colRange.stride();
        if (0 > colLb || colUb >= ncols) {
            throw new IndexOutOfBoundsException("Arrays.allocate(): matrix column indexes = 0.." + (ncols - 1) + ", column range = " + String.valueOf(colRange));
        }
        for (int i = rowLb; i <= rowUb; i += rowStride) {
            Object[] matrix_i = (Object[])Array.newInstance(type, ncols);
            matrix[i] = matrix_i;
            for (int j = colLb; j <= colUb; j += colStride) {
                matrix_i[j] = type.newInstance();
            }
        }
    }

    public static <T> void deallocate(T[] array) {
        Arrays.deallocate(array, new Range(0, array.length - 1));
    }

    public static <T> void deallocate(T[] array, Range range) {
        int lb = range.lb();
        int ub = range.ub();
        int stride = range.stride();
        if (0 > lb || ub >= array.length) {
            throw new IndexOutOfBoundsException("Arrays.deallocate(): array indexes = 0.." + (array.length - 1) + ", range = " + String.valueOf(range));
        }
        for (int i = lb; i <= ub; i += stride) {
            array[i] = null;
        }
    }

    public static void deallocate(boolean[][] matrix) {
        Arrays.deallocate(matrix, new Range(0, matrix.length - 1));
    }

    public static void deallocate(boolean[][] matrix, Range rowRange) {
        int rowLb = rowRange.lb();
        int rowUb = rowRange.ub();
        int rowStride = rowRange.stride();
        if (0 > rowLb || rowUb >= matrix.length) {
            throw new IndexOutOfBoundsException("Arrays.deallocate(): matrix row indexes = 0.." + (matrix.length - 1) + ", row range = " + String.valueOf(rowRange));
        }
        for (int i = rowLb; i <= rowUb; i += rowStride) {
            matrix[i] = null;
        }
    }

    public static void deallocate(byte[][] matrix) {
        Arrays.deallocate(matrix, new Range(0, matrix.length - 1));
    }

    public static void deallocate(byte[][] matrix, Range rowRange) {
        int rowLb = rowRange.lb();
        int rowUb = rowRange.ub();
        int rowStride = rowRange.stride();
        if (0 > rowLb || rowUb >= matrix.length) {
            throw new IndexOutOfBoundsException("Arrays.deallocate(): matrix row indexes = 0.." + (matrix.length - 1) + ", row range = " + String.valueOf(rowRange));
        }
        for (int i = rowLb; i <= rowUb; i += rowStride) {
            matrix[i] = null;
        }
    }

    public static void deallocate(char[][] matrix) {
        Arrays.deallocate(matrix, new Range(0, matrix.length - 1));
    }

    public static void deallocate(char[][] matrix, Range rowRange) {
        int rowLb = rowRange.lb();
        int rowUb = rowRange.ub();
        int rowStride = rowRange.stride();
        if (0 > rowLb || rowUb >= matrix.length) {
            throw new IndexOutOfBoundsException("Arrays.deallocate(): matrix row indexes = 0.." + (matrix.length - 1) + ", row range = " + String.valueOf(rowRange));
        }
        for (int i = rowLb; i <= rowUb; i += rowStride) {
            matrix[i] = null;
        }
    }

    public static void deallocate(double[][] matrix) {
        Arrays.deallocate(matrix, new Range(0, matrix.length - 1));
    }

    public static void deallocate(double[][] matrix, Range rowRange) {
        int rowLb = rowRange.lb();
        int rowUb = rowRange.ub();
        int rowStride = rowRange.stride();
        if (0 > rowLb || rowUb >= matrix.length) {
            throw new IndexOutOfBoundsException("Arrays.deallocate(): matrix row indexes = 0.." + (matrix.length - 1) + ", row range = " + String.valueOf(rowRange));
        }
        for (int i = rowLb; i <= rowUb; i += rowStride) {
            matrix[i] = null;
        }
    }

    public static void deallocate(float[][] matrix) {
        Arrays.deallocate(matrix, new Range(0, matrix.length - 1));
    }

    public static void deallocate(float[][] matrix, Range rowRange) {
        int rowLb = rowRange.lb();
        int rowUb = rowRange.ub();
        int rowStride = rowRange.stride();
        if (0 > rowLb || rowUb >= matrix.length) {
            throw new IndexOutOfBoundsException("Arrays.deallocate(): matrix row indexes = 0.." + (matrix.length - 1) + ", row range = " + String.valueOf(rowRange));
        }
        for (int i = rowLb; i <= rowUb; i += rowStride) {
            matrix[i] = null;
        }
    }

    public static void deallocate(int[][] matrix) {
        Arrays.deallocate(matrix, new Range(0, matrix.length - 1));
    }

    public static void deallocate(int[][] matrix, Range rowRange) {
        int rowLb = rowRange.lb();
        int rowUb = rowRange.ub();
        int rowStride = rowRange.stride();
        if (0 > rowLb || rowUb >= matrix.length) {
            throw new IndexOutOfBoundsException("Arrays.deallocate(): matrix row indexes = 0.." + (matrix.length - 1) + ", row range = " + String.valueOf(rowRange));
        }
        for (int i = rowLb; i <= rowUb; i += rowStride) {
            matrix[i] = null;
        }
    }

    public static void deallocate(long[][] matrix) {
        Arrays.deallocate(matrix, new Range(0, matrix.length - 1));
    }

    public static void deallocate(long[][] matrix, Range rowRange) {
        int rowLb = rowRange.lb();
        int rowUb = rowRange.ub();
        int rowStride = rowRange.stride();
        if (0 > rowLb || rowUb >= matrix.length) {
            throw new IndexOutOfBoundsException("Arrays.deallocate(): matrix row indexes = 0.." + (matrix.length - 1) + ", row range = " + String.valueOf(rowRange));
        }
        for (int i = rowLb; i <= rowUb; i += rowStride) {
            matrix[i] = null;
        }
    }

    public static void deallocate(short[][] matrix) {
        Arrays.deallocate(matrix, new Range(0, matrix.length - 1));
    }

    public static void deallocate(short[][] matrix, Range rowRange) {
        int rowLb = rowRange.lb();
        int rowUb = rowRange.ub();
        int rowStride = rowRange.stride();
        if (0 > rowLb || rowUb >= matrix.length) {
            throw new IndexOutOfBoundsException("Arrays.deallocate(): matrix row indexes = 0.." + (matrix.length - 1) + ", row range = " + String.valueOf(rowRange));
        }
        for (int i = rowLb; i <= rowUb; i += rowStride) {
            matrix[i] = null;
        }
    }

    public static <T> void deallocate(T[][] matrix) {
        Arrays.deallocate(matrix, new Range(0, matrix.length - 1));
    }

    public static <T> void deallocate(T[][] matrix, Range rowRange) {
        int rowLb = rowRange.lb();
        int rowUb = rowRange.ub();
        int rowStride = rowRange.stride();
        if (0 > rowLb || rowUb >= matrix.length) {
            throw new IndexOutOfBoundsException("Arrays.deallocate(): matrix row indexes = 0.." + (matrix.length - 1) + ", row range = " + String.valueOf(rowRange));
        }
        for (int i = rowLb; i <= rowUb; i += rowStride) {
            matrix[i] = null;
        }
    }

    public static <T> void deallocate(T[][] matrix, Range rowRange, Range colRange) {
        int rowLb = rowRange.lb();
        int rowUb = rowRange.ub();
        int rowStride = rowRange.stride();
        if (0 > rowLb || rowUb >= matrix.length) {
            throw new IndexOutOfBoundsException("Arrays.deallocate(): matrix row indexes = 0.." + (matrix.length - 1) + ", row range = " + String.valueOf(rowRange));
        }
        int colLb = colRange.lb();
        int colUb = colRange.ub();
        int colStride = colRange.stride();
        for (int i = rowLb; i <= rowUb; i += rowStride) {
            T[] matrix_i = matrix[i];
            int ncols = matrix_i.length;
            if (0 > colLb || colUb >= ncols) {
                throw new IndexOutOfBoundsException("Arrays.allocate(): matrix column indexes = 0.." + (ncols - 1) + ", column range = " + String.valueOf(colRange));
            }
            for (int j = colLb; j <= colUb; j += colStride) {
                matrix_i[j] = null;
            }
        }
    }

    public static void copy(boolean[] src, Range srcRange, boolean[] dst, Range dstRange) {
        block7: {
            int dstUpper;
            int srcUpper;
            int dstStride;
            int srcStride;
            int dstLower;
            int srcLower;
            block8: {
                block6: {
                    int len = Math.min(srcRange.length(), dstRange.length());
                    if (len == 0) {
                        return;
                    }
                    srcLower = srcRange.lb();
                    dstLower = dstRange.lb();
                    if (src == dst && srcLower == dstLower) {
                        return;
                    }
                    srcStride = srcRange.stride();
                    dstStride = dstRange.stride();
                    if (srcStride != 1 || dstStride != 1) break block6;
                    System.arraycopy(src, srcLower, dst, dstLower, len);
                    break block7;
                }
                srcUpper = srcRange.ub();
                dstUpper = dstRange.ub();
                if (0 > srcLower || srcUpper >= src.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src indexes = 0.." + (src.length - 1) + ", srcRange = " + String.valueOf(srcRange));
                }
                if (0 > dstLower || dstUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst indexes = 0.." + (dst.length - 1) + ", dstRange = " + String.valueOf(dstRange));
                }
                if (src == dst && srcLower <= dstLower) break block8;
                int i = srcLower;
                int j = dstLower;
                while (i <= srcUpper) {
                    dst[j] = src[i];
                    i += srcStride;
                    j += dstStride;
                }
                break block7;
            }
            if (srcLower >= dstLower) break block7;
            int i = srcUpper;
            int j = dstUpper;
            while (i >= srcLower) {
                dst[j] = src[i];
                i -= srcStride;
                j -= dstStride;
            }
        }
    }

    public static void copy(byte[] src, Range srcRange, byte[] dst, Range dstRange) {
        block7: {
            int dstUpper;
            int srcUpper;
            int dstStride;
            int srcStride;
            int dstLower;
            int srcLower;
            block8: {
                block6: {
                    int len = Math.min(srcRange.length(), dstRange.length());
                    if (len == 0) {
                        return;
                    }
                    srcLower = srcRange.lb();
                    dstLower = dstRange.lb();
                    if (src == dst && srcLower == dstLower) {
                        return;
                    }
                    srcStride = srcRange.stride();
                    dstStride = dstRange.stride();
                    if (srcStride != 1 || dstStride != 1) break block6;
                    System.arraycopy(src, srcLower, dst, dstLower, len);
                    break block7;
                }
                srcUpper = srcRange.ub();
                dstUpper = dstRange.ub();
                if (0 > srcLower || srcUpper >= src.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src indexes = 0.." + (src.length - 1) + ", srcRange = " + String.valueOf(srcRange));
                }
                if (0 > dstLower || dstUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst indexes = 0.." + (dst.length - 1) + ", dstRange = " + String.valueOf(dstRange));
                }
                if (src == dst && srcLower <= dstLower) break block8;
                int i = srcLower;
                int j = dstLower;
                while (i <= srcUpper) {
                    dst[j] = src[i];
                    i += srcStride;
                    j += dstStride;
                }
                break block7;
            }
            if (srcLower >= dstLower) break block7;
            int i = srcUpper;
            int j = dstUpper;
            while (i >= srcLower) {
                dst[j] = src[i];
                i -= srcStride;
                j -= dstStride;
            }
        }
    }

    public static void copy(char[] src, Range srcRange, char[] dst, Range dstRange) {
        block7: {
            int dstUpper;
            int srcUpper;
            int dstStride;
            int srcStride;
            int dstLower;
            int srcLower;
            block8: {
                block6: {
                    int len = Math.min(srcRange.length(), dstRange.length());
                    if (len == 0) {
                        return;
                    }
                    srcLower = srcRange.lb();
                    dstLower = dstRange.lb();
                    if (src == dst && srcLower == dstLower) {
                        return;
                    }
                    srcStride = srcRange.stride();
                    dstStride = dstRange.stride();
                    if (srcStride != 1 || dstStride != 1) break block6;
                    System.arraycopy(src, srcLower, dst, dstLower, len);
                    break block7;
                }
                srcUpper = srcRange.ub();
                dstUpper = dstRange.ub();
                if (0 > srcLower || srcUpper >= src.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src indexes = 0.." + (src.length - 1) + ", srcRange = " + String.valueOf(srcRange));
                }
                if (0 > dstLower || dstUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst indexes = 0.." + (dst.length - 1) + ", dstRange = " + String.valueOf(dstRange));
                }
                if (src == dst && srcLower <= dstLower) break block8;
                int i = srcLower;
                int j = dstLower;
                while (i <= srcUpper) {
                    dst[j] = src[i];
                    i += srcStride;
                    j += dstStride;
                }
                break block7;
            }
            if (srcLower >= dstLower) break block7;
            int i = srcUpper;
            int j = dstUpper;
            while (i >= srcLower) {
                dst[j] = src[i];
                i -= srcStride;
                j -= dstStride;
            }
        }
    }

    public static void copy(double[] src, Range srcRange, double[] dst, Range dstRange) {
        block7: {
            int dstUpper;
            int srcUpper;
            int dstStride;
            int srcStride;
            int dstLower;
            int srcLower;
            block8: {
                block6: {
                    int len = Math.min(srcRange.length(), dstRange.length());
                    if (len == 0) {
                        return;
                    }
                    srcLower = srcRange.lb();
                    dstLower = dstRange.lb();
                    if (src == dst && srcLower == dstLower) {
                        return;
                    }
                    srcStride = srcRange.stride();
                    dstStride = dstRange.stride();
                    if (srcStride != 1 || dstStride != 1) break block6;
                    System.arraycopy(src, srcLower, dst, dstLower, len);
                    break block7;
                }
                srcUpper = srcRange.ub();
                dstUpper = dstRange.ub();
                if (0 > srcLower || srcUpper >= src.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src indexes = 0.." + (src.length - 1) + ", srcRange = " + String.valueOf(srcRange));
                }
                if (0 > dstLower || dstUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst indexes = 0.." + (dst.length - 1) + ", dstRange = " + String.valueOf(dstRange));
                }
                if (src == dst && srcLower <= dstLower) break block8;
                int i = srcLower;
                int j = dstLower;
                while (i <= srcUpper) {
                    dst[j] = src[i];
                    i += srcStride;
                    j += dstStride;
                }
                break block7;
            }
            if (srcLower >= dstLower) break block7;
            int i = srcUpper;
            int j = dstUpper;
            while (i >= srcLower) {
                dst[j] = src[i];
                i -= srcStride;
                j -= dstStride;
            }
        }
    }

    public static void copy(float[] src, Range srcRange, float[] dst, Range dstRange) {
        block7: {
            int dstUpper;
            int srcUpper;
            int dstStride;
            int srcStride;
            int dstLower;
            int srcLower;
            block8: {
                block6: {
                    int len = Math.min(srcRange.length(), dstRange.length());
                    if (len == 0) {
                        return;
                    }
                    srcLower = srcRange.lb();
                    dstLower = dstRange.lb();
                    if (src == dst && srcLower == dstLower) {
                        return;
                    }
                    srcStride = srcRange.stride();
                    dstStride = dstRange.stride();
                    if (srcStride != 1 || dstStride != 1) break block6;
                    System.arraycopy(src, srcLower, dst, dstLower, len);
                    break block7;
                }
                srcUpper = srcRange.ub();
                dstUpper = dstRange.ub();
                if (0 > srcLower || srcUpper >= src.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src indexes = 0.." + (src.length - 1) + ", srcRange = " + String.valueOf(srcRange));
                }
                if (0 > dstLower || dstUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst indexes = 0.." + (dst.length - 1) + ", dstRange = " + String.valueOf(dstRange));
                }
                if (src == dst && srcLower <= dstLower) break block8;
                int i = srcLower;
                int j = dstLower;
                while (i <= srcUpper) {
                    dst[j] = src[i];
                    i += srcStride;
                    j += dstStride;
                }
                break block7;
            }
            if (srcLower >= dstLower) break block7;
            int i = srcUpper;
            int j = dstUpper;
            while (i >= srcLower) {
                dst[j] = src[i];
                i -= srcStride;
                j -= dstStride;
            }
        }
    }

    public static void copy(int[] src, Range srcRange, int[] dst, Range dstRange) {
        block7: {
            int dstUpper;
            int srcUpper;
            int dstStride;
            int srcStride;
            int dstLower;
            int srcLower;
            block8: {
                block6: {
                    int len = Math.min(srcRange.length(), dstRange.length());
                    if (len == 0) {
                        return;
                    }
                    srcLower = srcRange.lb();
                    dstLower = dstRange.lb();
                    if (src == dst && srcLower == dstLower) {
                        return;
                    }
                    srcStride = srcRange.stride();
                    dstStride = dstRange.stride();
                    if (srcStride != 1 || dstStride != 1) break block6;
                    System.arraycopy(src, srcLower, dst, dstLower, len);
                    break block7;
                }
                srcUpper = srcRange.ub();
                dstUpper = dstRange.ub();
                if (0 > srcLower || srcUpper >= src.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src indexes = 0.." + (src.length - 1) + ", srcRange = " + String.valueOf(srcRange));
                }
                if (0 > dstLower || dstUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst indexes = 0.." + (dst.length - 1) + ", dstRange = " + String.valueOf(dstRange));
                }
                if (src == dst && srcLower <= dstLower) break block8;
                int i = srcLower;
                int j = dstLower;
                while (i <= srcUpper) {
                    dst[j] = src[i];
                    i += srcStride;
                    j += dstStride;
                }
                break block7;
            }
            if (srcLower >= dstLower) break block7;
            int i = srcUpper;
            int j = dstUpper;
            while (i >= srcLower) {
                dst[j] = src[i];
                i -= srcStride;
                j -= dstStride;
            }
        }
    }

    public static void copy(long[] src, Range srcRange, long[] dst, Range dstRange) {
        block7: {
            int dstUpper;
            int srcUpper;
            int dstStride;
            int srcStride;
            int dstLower;
            int srcLower;
            block8: {
                block6: {
                    int len = Math.min(srcRange.length(), dstRange.length());
                    if (len == 0) {
                        return;
                    }
                    srcLower = srcRange.lb();
                    dstLower = dstRange.lb();
                    if (src == dst && srcLower == dstLower) {
                        return;
                    }
                    srcStride = srcRange.stride();
                    dstStride = dstRange.stride();
                    if (srcStride != 1 || dstStride != 1) break block6;
                    System.arraycopy(src, srcLower, dst, dstLower, len);
                    break block7;
                }
                srcUpper = srcRange.ub();
                dstUpper = dstRange.ub();
                if (0 > srcLower || srcUpper >= src.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src indexes = 0.." + (src.length - 1) + ", srcRange = " + String.valueOf(srcRange));
                }
                if (0 > dstLower || dstUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst indexes = 0.." + (dst.length - 1) + ", dstRange = " + String.valueOf(dstRange));
                }
                if (src == dst && srcLower <= dstLower) break block8;
                int i = srcLower;
                int j = dstLower;
                while (i <= srcUpper) {
                    dst[j] = src[i];
                    i += srcStride;
                    j += dstStride;
                }
                break block7;
            }
            if (srcLower >= dstLower) break block7;
            int i = srcUpper;
            int j = dstUpper;
            while (i >= srcLower) {
                dst[j] = src[i];
                i -= srcStride;
                j -= dstStride;
            }
        }
    }

    public static void copy(short[] src, Range srcRange, short[] dst, Range dstRange) {
        block7: {
            int dstUpper;
            int srcUpper;
            int dstStride;
            int srcStride;
            int dstLower;
            int srcLower;
            block8: {
                block6: {
                    int len = Math.min(srcRange.length(), dstRange.length());
                    if (len == 0) {
                        return;
                    }
                    srcLower = srcRange.lb();
                    dstLower = dstRange.lb();
                    if (src == dst && srcLower == dstLower) {
                        return;
                    }
                    srcStride = srcRange.stride();
                    dstStride = dstRange.stride();
                    if (srcStride != 1 || dstStride != 1) break block6;
                    System.arraycopy(src, srcLower, dst, dstLower, len);
                    break block7;
                }
                srcUpper = srcRange.ub();
                dstUpper = dstRange.ub();
                if (0 > srcLower || srcUpper >= src.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src indexes = 0.." + (src.length - 1) + ", srcRange = " + String.valueOf(srcRange));
                }
                if (0 > dstLower || dstUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst indexes = 0.." + (dst.length - 1) + ", dstRange = " + String.valueOf(dstRange));
                }
                if (src == dst && srcLower <= dstLower) break block8;
                int i = srcLower;
                int j = dstLower;
                while (i <= srcUpper) {
                    dst[j] = src[i];
                    i += srcStride;
                    j += dstStride;
                }
                break block7;
            }
            if (srcLower >= dstLower) break block7;
            int i = srcUpper;
            int j = dstUpper;
            while (i >= srcLower) {
                dst[j] = src[i];
                i -= srcStride;
                j -= dstStride;
            }
        }
    }

    public static <DT, ST extends DT> void copy(ST[] src, Range srcRange, DT[] dst, Range dstRange) {
        block7: {
            int dstUpper;
            int srcUpper;
            int dstStride;
            int srcStride;
            int dstLower;
            int srcLower;
            block8: {
                block6: {
                    int len = Math.min(srcRange.length(), dstRange.length());
                    if (len == 0) {
                        return;
                    }
                    srcLower = srcRange.lb();
                    dstLower = dstRange.lb();
                    if (src == dst && srcLower == dstLower) {
                        return;
                    }
                    srcStride = srcRange.stride();
                    dstStride = dstRange.stride();
                    if (srcStride != 1 || dstStride != 1) break block6;
                    System.arraycopy(src, srcLower, dst, dstLower, len);
                    break block7;
                }
                srcUpper = srcRange.ub();
                dstUpper = dstRange.ub();
                if (0 > srcLower || srcUpper >= src.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src indexes = 0.." + (src.length - 1) + ", srcRange = " + String.valueOf(srcRange));
                }
                if (0 > dstLower || dstUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst indexes = 0.." + (dst.length - 1) + ", dstRange = " + String.valueOf(dstRange));
                }
                if (src == dst && srcLower <= dstLower) break block8;
                int i = srcLower;
                int j = dstLower;
                while (i <= srcUpper) {
                    dst[j] = src[i];
                    i += srcStride;
                    j += dstStride;
                }
                break block7;
            }
            if (srcLower >= dstLower) break block7;
            int i = srcUpper;
            int j = dstUpper;
            while (i >= srcLower) {
                dst[j] = src[i];
                i -= srcStride;
                j -= dstStride;
            }
        }
    }

    public static void copy(boolean[][] src, Range srcRowRange, Range srcColRange, boolean[][] dst, Range dstRowRange, Range dstColRange) {
        block6: {
            int dstRowUpper;
            int srcRowUpper;
            int dstRowStride;
            int srcRowStride;
            int dstRowLower;
            int srcRowLower;
            block5: {
                int len = Math.min(srcRowRange.length(), dstRowRange.length());
                if (len == 0) {
                    return;
                }
                srcRowLower = srcRowRange.lb();
                dstRowLower = dstRowRange.lb();
                srcRowStride = srcRowRange.stride();
                dstRowStride = dstRowRange.stride();
                srcRowUpper = srcRowRange.ub();
                dstRowUpper = dstRowRange.ub();
                if (0 > srcRowLower || srcRowUpper >= src.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src row indexes = 0.." + (src.length - 1) + ", srcRowRange = " + String.valueOf(srcRowRange));
                }
                if (0 > dstRowLower || dstRowUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst row indexes = 0.." + (dst.length - 1) + ", dstRowRange = " + String.valueOf(dstRowRange));
                }
                if (src == dst && srcRowLower <= dstRowLower) break block5;
                int i = srcRowLower;
                int j = dstRowLower;
                while (i <= srcRowUpper) {
                    Arrays.copy(src[i], srcColRange, dst[j], dstColRange);
                    i += srcRowStride;
                    j += dstRowStride;
                }
                break block6;
            }
            if (srcRowLower >= dstRowLower) break block6;
            int i = srcRowUpper;
            int j = dstRowUpper;
            while (i >= srcRowLower) {
                Arrays.copy(src[i], srcColRange, dst[j], dstColRange);
                i -= srcRowStride;
                j -= dstRowStride;
            }
        }
    }

    public static void copy(byte[][] src, Range srcRowRange, Range srcColRange, byte[][] dst, Range dstRowRange, Range dstColRange) {
        block6: {
            int dstRowUpper;
            int srcRowUpper;
            int dstRowStride;
            int srcRowStride;
            int dstRowLower;
            int srcRowLower;
            block5: {
                int len = Math.min(srcRowRange.length(), dstRowRange.length());
                if (len == 0) {
                    return;
                }
                srcRowLower = srcRowRange.lb();
                dstRowLower = dstRowRange.lb();
                srcRowStride = srcRowRange.stride();
                dstRowStride = dstRowRange.stride();
                srcRowUpper = srcRowRange.ub();
                dstRowUpper = dstRowRange.ub();
                if (0 > srcRowLower || srcRowUpper >= src.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src row indexes = 0.." + (src.length - 1) + ", srcRowRange = " + String.valueOf(srcRowRange));
                }
                if (0 > dstRowLower || dstRowUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst row indexes = 0.." + (dst.length - 1) + ", dstRowRange = " + String.valueOf(dstRowRange));
                }
                if (src == dst && srcRowLower <= dstRowLower) break block5;
                int i = srcRowLower;
                int j = dstRowLower;
                while (i <= srcRowUpper) {
                    Arrays.copy(src[i], srcColRange, dst[j], dstColRange);
                    i += srcRowStride;
                    j += dstRowStride;
                }
                break block6;
            }
            if (srcRowLower >= dstRowLower) break block6;
            int i = srcRowUpper;
            int j = dstRowUpper;
            while (i >= srcRowLower) {
                Arrays.copy(src[i], srcColRange, dst[j], dstColRange);
                i -= srcRowStride;
                j -= dstRowStride;
            }
        }
    }

    public static void copy(char[][] src, Range srcRowRange, Range srcColRange, char[][] dst, Range dstRowRange, Range dstColRange) {
        block6: {
            int dstRowUpper;
            int srcRowUpper;
            int dstRowStride;
            int srcRowStride;
            int dstRowLower;
            int srcRowLower;
            block5: {
                int len = Math.min(srcRowRange.length(), dstRowRange.length());
                if (len == 0) {
                    return;
                }
                srcRowLower = srcRowRange.lb();
                dstRowLower = dstRowRange.lb();
                srcRowStride = srcRowRange.stride();
                dstRowStride = dstRowRange.stride();
                srcRowUpper = srcRowRange.ub();
                dstRowUpper = dstRowRange.ub();
                if (0 > srcRowLower || srcRowUpper >= src.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src row indexes = 0.." + (src.length - 1) + ", srcRowRange = " + String.valueOf(srcRowRange));
                }
                if (0 > dstRowLower || dstRowUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst row indexes = 0.." + (dst.length - 1) + ", dstRowRange = " + String.valueOf(dstRowRange));
                }
                if (src == dst && srcRowLower <= dstRowLower) break block5;
                int i = srcRowLower;
                int j = dstRowLower;
                while (i <= srcRowUpper) {
                    Arrays.copy(src[i], srcColRange, dst[j], dstColRange);
                    i += srcRowStride;
                    j += dstRowStride;
                }
                break block6;
            }
            if (srcRowLower >= dstRowLower) break block6;
            int i = srcRowUpper;
            int j = dstRowUpper;
            while (i >= srcRowLower) {
                Arrays.copy(src[i], srcColRange, dst[j], dstColRange);
                i -= srcRowStride;
                j -= dstRowStride;
            }
        }
    }

    public static void copy(double[][] src, Range srcRowRange, Range srcColRange, double[][] dst, Range dstRowRange, Range dstColRange) {
        block6: {
            int dstRowUpper;
            int srcRowUpper;
            int dstRowStride;
            int srcRowStride;
            int dstRowLower;
            int srcRowLower;
            block5: {
                int len = Math.min(srcRowRange.length(), dstRowRange.length());
                if (len == 0) {
                    return;
                }
                srcRowLower = srcRowRange.lb();
                dstRowLower = dstRowRange.lb();
                srcRowStride = srcRowRange.stride();
                dstRowStride = dstRowRange.stride();
                srcRowUpper = srcRowRange.ub();
                dstRowUpper = dstRowRange.ub();
                if (0 > srcRowLower || srcRowUpper >= src.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src row indexes = 0.." + (src.length - 1) + ", srcRowRange = " + String.valueOf(srcRowRange));
                }
                if (0 > dstRowLower || dstRowUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst row indexes = 0.." + (dst.length - 1) + ", dstRowRange = " + String.valueOf(dstRowRange));
                }
                if (src == dst && srcRowLower <= dstRowLower) break block5;
                int i = srcRowLower;
                int j = dstRowLower;
                while (i <= srcRowUpper) {
                    Arrays.copy(src[i], srcColRange, dst[j], dstColRange);
                    i += srcRowStride;
                    j += dstRowStride;
                }
                break block6;
            }
            if (srcRowLower >= dstRowLower) break block6;
            int i = srcRowUpper;
            int j = dstRowUpper;
            while (i >= srcRowLower) {
                Arrays.copy(src[i], srcColRange, dst[j], dstColRange);
                i -= srcRowStride;
                j -= dstRowStride;
            }
        }
    }

    public static void copy(float[][] src, Range srcRowRange, Range srcColRange, float[][] dst, Range dstRowRange, Range dstColRange) {
        block6: {
            int dstRowUpper;
            int srcRowUpper;
            int dstRowStride;
            int srcRowStride;
            int dstRowLower;
            int srcRowLower;
            block5: {
                int len = Math.min(srcRowRange.length(), dstRowRange.length());
                if (len == 0) {
                    return;
                }
                srcRowLower = srcRowRange.lb();
                dstRowLower = dstRowRange.lb();
                srcRowStride = srcRowRange.stride();
                dstRowStride = dstRowRange.stride();
                srcRowUpper = srcRowRange.ub();
                dstRowUpper = dstRowRange.ub();
                if (0 > srcRowLower || srcRowUpper >= src.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src row indexes = 0.." + (src.length - 1) + ", srcRowRange = " + String.valueOf(srcRowRange));
                }
                if (0 > dstRowLower || dstRowUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst row indexes = 0.." + (dst.length - 1) + ", dstRowRange = " + String.valueOf(dstRowRange));
                }
                if (src == dst && srcRowLower <= dstRowLower) break block5;
                int i = srcRowLower;
                int j = dstRowLower;
                while (i <= srcRowUpper) {
                    Arrays.copy(src[i], srcColRange, dst[j], dstColRange);
                    i += srcRowStride;
                    j += dstRowStride;
                }
                break block6;
            }
            if (srcRowLower >= dstRowLower) break block6;
            int i = srcRowUpper;
            int j = dstRowUpper;
            while (i >= srcRowLower) {
                Arrays.copy(src[i], srcColRange, dst[j], dstColRange);
                i -= srcRowStride;
                j -= dstRowStride;
            }
        }
    }

    public static void copy(int[][] src, Range srcRowRange, Range srcColRange, int[][] dst, Range dstRowRange, Range dstColRange) {
        block6: {
            int dstRowUpper;
            int srcRowUpper;
            int dstRowStride;
            int srcRowStride;
            int dstRowLower;
            int srcRowLower;
            block5: {
                int len = Math.min(srcRowRange.length(), dstRowRange.length());
                if (len == 0) {
                    return;
                }
                srcRowLower = srcRowRange.lb();
                dstRowLower = dstRowRange.lb();
                srcRowStride = srcRowRange.stride();
                dstRowStride = dstRowRange.stride();
                srcRowUpper = srcRowRange.ub();
                dstRowUpper = dstRowRange.ub();
                if (0 > srcRowLower || srcRowUpper >= src.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src row indexes = 0.." + (src.length - 1) + ", srcRowRange = " + String.valueOf(srcRowRange));
                }
                if (0 > dstRowLower || dstRowUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst row indexes = 0.." + (dst.length - 1) + ", dstRowRange = " + String.valueOf(dstRowRange));
                }
                if (src == dst && srcRowLower <= dstRowLower) break block5;
                int i = srcRowLower;
                int j = dstRowLower;
                while (i <= srcRowUpper) {
                    Arrays.copy(src[i], srcColRange, dst[j], dstColRange);
                    i += srcRowStride;
                    j += dstRowStride;
                }
                break block6;
            }
            if (srcRowLower >= dstRowLower) break block6;
            int i = srcRowUpper;
            int j = dstRowUpper;
            while (i >= srcRowLower) {
                Arrays.copy(src[i], srcColRange, dst[j], dstColRange);
                i -= srcRowStride;
                j -= dstRowStride;
            }
        }
    }

    public static void copy(long[][] src, Range srcRowRange, Range srcColRange, long[][] dst, Range dstRowRange, Range dstColRange) {
        block6: {
            int dstRowUpper;
            int srcRowUpper;
            int dstRowStride;
            int srcRowStride;
            int dstRowLower;
            int srcRowLower;
            block5: {
                int len = Math.min(srcRowRange.length(), dstRowRange.length());
                if (len == 0) {
                    return;
                }
                srcRowLower = srcRowRange.lb();
                dstRowLower = dstRowRange.lb();
                srcRowStride = srcRowRange.stride();
                dstRowStride = dstRowRange.stride();
                srcRowUpper = srcRowRange.ub();
                dstRowUpper = dstRowRange.ub();
                if (0 > srcRowLower || srcRowUpper >= src.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src row indexes = 0.." + (src.length - 1) + ", srcRowRange = " + String.valueOf(srcRowRange));
                }
                if (0 > dstRowLower || dstRowUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst row indexes = 0.." + (dst.length - 1) + ", dstRowRange = " + String.valueOf(dstRowRange));
                }
                if (src == dst && srcRowLower <= dstRowLower) break block5;
                int i = srcRowLower;
                int j = dstRowLower;
                while (i <= srcRowUpper) {
                    Arrays.copy(src[i], srcColRange, dst[j], dstColRange);
                    i += srcRowStride;
                    j += dstRowStride;
                }
                break block6;
            }
            if (srcRowLower >= dstRowLower) break block6;
            int i = srcRowUpper;
            int j = dstRowUpper;
            while (i >= srcRowLower) {
                Arrays.copy(src[i], srcColRange, dst[j], dstColRange);
                i -= srcRowStride;
                j -= dstRowStride;
            }
        }
    }

    public static void copy(short[][] src, Range srcRowRange, Range srcColRange, short[][] dst, Range dstRowRange, Range dstColRange) {
        block6: {
            int dstRowUpper;
            int srcRowUpper;
            int dstRowStride;
            int srcRowStride;
            int dstRowLower;
            int srcRowLower;
            block5: {
                int len = Math.min(srcRowRange.length(), dstRowRange.length());
                if (len == 0) {
                    return;
                }
                srcRowLower = srcRowRange.lb();
                dstRowLower = dstRowRange.lb();
                srcRowStride = srcRowRange.stride();
                dstRowStride = dstRowRange.stride();
                srcRowUpper = srcRowRange.ub();
                dstRowUpper = dstRowRange.ub();
                if (0 > srcRowLower || srcRowUpper >= src.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src row indexes = 0.." + (src.length - 1) + ", srcRowRange = " + String.valueOf(srcRowRange));
                }
                if (0 > dstRowLower || dstRowUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst row indexes = 0.." + (dst.length - 1) + ", dstRowRange = " + String.valueOf(dstRowRange));
                }
                if (src == dst && srcRowLower <= dstRowLower) break block5;
                int i = srcRowLower;
                int j = dstRowLower;
                while (i <= srcRowUpper) {
                    Arrays.copy(src[i], srcColRange, dst[j], dstColRange);
                    i += srcRowStride;
                    j += dstRowStride;
                }
                break block6;
            }
            if (srcRowLower >= dstRowLower) break block6;
            int i = srcRowUpper;
            int j = dstRowUpper;
            while (i >= srcRowLower) {
                Arrays.copy(src[i], srcColRange, dst[j], dstColRange);
                i -= srcRowStride;
                j -= dstRowStride;
            }
        }
    }

    public static <DT, ST extends DT> void copy(ST[][] src, Range srcRowRange, Range srcColRange, DT[][] dst, Range dstRowRange, Range dstColRange) {
        block6: {
            int dstRowUpper;
            int srcRowUpper;
            int dstRowStride;
            int srcRowStride;
            int dstRowLower;
            int srcRowLower;
            block5: {
                int len = Math.min(srcRowRange.length(), dstRowRange.length());
                if (len == 0) {
                    return;
                }
                srcRowLower = srcRowRange.lb();
                dstRowLower = dstRowRange.lb();
                srcRowStride = srcRowRange.stride();
                dstRowStride = dstRowRange.stride();
                srcRowUpper = srcRowRange.ub();
                dstRowUpper = dstRowRange.ub();
                if (0 > srcRowLower || srcRowUpper >= src.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): src row indexes = 0.." + (src.length - 1) + ", srcRowRange = " + String.valueOf(srcRowRange));
                }
                if (0 > dstRowLower || dstRowUpper >= dst.length) {
                    throw new IndexOutOfBoundsException("Arrays.copy(): dst row indexes = 0.." + (dst.length - 1) + ", dstRowRange = " + String.valueOf(dstRowRange));
                }
                if (src == dst && srcRowLower <= dstRowLower) break block5;
                int i = srcRowLower;
                int j = dstRowLower;
                while (i <= srcRowUpper) {
                    Arrays.copy(src[i], srcColRange, dst[j], dstColRange);
                    i += srcRowStride;
                    j += dstRowStride;
                }
                break block6;
            }
            if (srcRowLower >= dstRowLower) break block6;
            int i = srcRowUpper;
            int j = dstRowUpper;
            while (i >= srcRowLower) {
                Arrays.copy(src[i], srcColRange, dst[j], dstColRange);
                i -= srcRowStride;
                j -= dstRowStride;
            }
        }
    }

    public static int length(boolean[] array) {
        return array == null ? 0 : array.length;
    }

    public static int length(byte[] array) {
        return array == null ? 0 : array.length;
    }

    public static int length(char[] array) {
        return array == null ? 0 : array.length;
    }

    public static int length(double[] array) {
        return array == null ? 0 : array.length;
    }

    public static int length(float[] array) {
        return array == null ? 0 : array.length;
    }

    public static int length(int[] array) {
        return array == null ? 0 : array.length;
    }

    public static int length(long[] array) {
        return array == null ? 0 : array.length;
    }

    public static int length(short[] array) {
        return array == null ? 0 : array.length;
    }

    public static <T> int length(T[] array) {
        return array == null ? 0 : array.length;
    }

    public static int rowLength(boolean[][] matrix) {
        return matrix == null ? 0 : matrix.length;
    }

    public static int rowLength(byte[][] matrix) {
        return matrix == null ? 0 : matrix.length;
    }

    public static int rowLength(char[][] matrix) {
        return matrix == null ? 0 : matrix.length;
    }

    public static int rowLength(double[][] matrix) {
        return matrix == null ? 0 : matrix.length;
    }

    public static int rowLength(float[][] matrix) {
        return matrix == null ? 0 : matrix.length;
    }

    public static int rowLength(int[][] matrix) {
        return matrix == null ? 0 : matrix.length;
    }

    public static int rowLength(long[][] matrix) {
        return matrix == null ? 0 : matrix.length;
    }

    public static int rowLength(short[][] matrix) {
        return matrix == null ? 0 : matrix.length;
    }

    public static <T> int rowLength(T[][] matrix) {
        return matrix == null ? 0 : matrix.length;
    }

    public static int colLength(boolean[][] matrix, int i) {
        return matrix == null ? 0 : Arrays.length(matrix[i]);
    }

    public static int colLength(byte[][] matrix, int i) {
        return matrix == null ? 0 : Arrays.length(matrix[i]);
    }

    public static int colLength(char[][] matrix, int i) {
        return matrix == null ? 0 : Arrays.length(matrix[i]);
    }

    public static int colLength(double[][] matrix, int i) {
        return matrix == null ? 0 : Arrays.length(matrix[i]);
    }

    public static int colLength(float[][] matrix, int i) {
        return matrix == null ? 0 : Arrays.length(matrix[i]);
    }

    public static int colLength(int[][] matrix, int i) {
        return matrix == null ? 0 : Arrays.length(matrix[i]);
    }

    public static int colLength(long[][] matrix, int i) {
        return matrix == null ? 0 : Arrays.length(matrix[i]);
    }

    public static int colLength(short[][] matrix, int i) {
        return matrix == null ? 0 : Arrays.length(matrix[i]);
    }

    public static <T> int colLength(T[][] matrix, int i) {
        return matrix == null ? 0 : Arrays.length(matrix[i]);
    }
}

