/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.replica;

import edu.rit.mp.DoubleBuf;
import edu.rit.mp.buf.DoubleItemBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.reduction.DoubleOp;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public class ReplicatedDouble
extends Number {
    private static final long serialVersionUID = 1L;
    private DoubleOp myOp;
    private AtomicLong myValue;
    private int myTag;
    private Comm myComm;
    private Receiver myReceiver;

    public ReplicatedDouble(DoubleOp op) {
        this(op, 0.0, 0, Comm.world());
    }

    public ReplicatedDouble(DoubleOp op, double initialValue) {
        this(op, initialValue, 0, Comm.world());
    }

    public ReplicatedDouble(DoubleOp op, double initialValue, int tag) {
        this(op, initialValue, tag, Comm.world());
    }

    public ReplicatedDouble(DoubleOp op, double initialValue, int tag, Comm comm) {
        if (op == null) {
            throw new NullPointerException("ReplicatedDouble(): op is null");
        }
        if (comm == null) {
            throw new NullPointerException("ReplicatedDouble(): comm is null");
        }
        this.myOp = op;
        this.myValue = new AtomicLong(Double.doubleToLongBits(initialValue));
        this.myTag = tag;
        this.myComm = comm;
        this.myReceiver = new Receiver(this);
        this.myReceiver.setDaemon(true);
        this.myReceiver.start();
    }

    public double get() {
        return Double.longBitsToDouble(this.myValue.get());
    }

    public double reduce(double value) throws IOException {
        double oldvalue;
        double newvalue;
        long newlong;
        long oldlong;
        while (!this.myValue.compareAndSet(oldlong = this.myValue.get(), newlong = Double.doubleToLongBits(newvalue = this.myOp.op(oldvalue = Double.longBitsToDouble(oldlong), value)))) {
        }
        if (newvalue != oldvalue) {
            this.myComm.floodSend(this.myTag, DoubleBuf.buffer(newvalue));
        }
        return newvalue;
    }

    public String toString() {
        return Double.toString(this.get());
    }

    @Override
    public int intValue() {
        return (int)this.get();
    }

    @Override
    public long longValue() {
        return (long)this.get();
    }

    @Override
    public float floatValue() {
        return (float)this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    private class Receiver
    extends Thread {
        final /* synthetic */ ReplicatedDouble this$0;

        private Receiver(ReplicatedDouble replicatedDouble) {
            ReplicatedDouble replicatedDouble2 = replicatedDouble;
            Objects.requireNonNull(replicatedDouble2);
            this.this$0 = replicatedDouble2;
        }

        @Override
        public void run() {
            DoubleItemBuf buf = DoubleBuf.buffer();
            try {
                while (true) {
                    double oldvalue;
                    double newvalue;
                    long newlong;
                    long oldlong;
                    this.this$0.myComm.floodReceive(this.this$0.myTag, buf);
                    while (!this.this$0.myValue.compareAndSet(oldlong = this.this$0.myValue.get(), newlong = Double.doubleToLongBits(newvalue = this.this$0.myOp.op(oldvalue = Double.longBitsToDouble(oldlong), buf.item)))) {
                    }
                }
            }
            catch (Throwable exc) {
                exc.printStackTrace(System.err);
                return;
            }
        }
    }
}

