/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.replica;

import edu.rit.mp.CharacterBuf;
import edu.rit.mp.buf.CharacterItemBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.reduction.CharacterOp;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public class ReplicatedCharacter
extends Number {
    private static final long serialVersionUID = 1L;
    private final CharacterOp myOp;
    private final AtomicInteger myValue;
    private final int myTag;
    private final Comm myComm;
    private final Receiver myReceiver;

    public ReplicatedCharacter(CharacterOp op) {
        this(op, '\u0000', 0, Comm.world());
    }

    public ReplicatedCharacter(CharacterOp op, char initialValue) {
        this(op, initialValue, 0, Comm.world());
    }

    public ReplicatedCharacter(CharacterOp op, char initialValue, int tag) {
        this(op, initialValue, tag, Comm.world());
    }

    public ReplicatedCharacter(CharacterOp op, char initialValue, int tag, Comm comm) {
        if (op == null) {
            throw new NullPointerException("ReplicatedCharacter(): op is null");
        }
        if (comm == null) {
            throw new NullPointerException("ReplicatedCharacter(): comm is null");
        }
        this.myOp = op;
        this.myValue = new AtomicInteger(initialValue);
        this.myTag = tag;
        this.myComm = comm;
        this.myReceiver = new Receiver(this);
        this.myReceiver.setDaemon(true);
        this.myReceiver.start();
    }

    public char get() {
        return (char)this.myValue.get();
    }

    public char reduce(char value) throws IOException {
        char newvalue;
        char oldvalue;
        while (!this.myValue.compareAndSet(oldvalue = (char)this.myValue.get(), newvalue = this.myOp.op(oldvalue, value))) {
        }
        if (newvalue != oldvalue) {
            this.myComm.floodSend(this.myTag, CharacterBuf.buffer(newvalue));
        }
        return newvalue;
    }

    public String toString() {
        return Character.toString(this.get());
    }

    @Override
    public int intValue() {
        return this.get();
    }

    @Override
    public long longValue() {
        return this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    private class Receiver
    extends Thread {
        final /* synthetic */ ReplicatedCharacter this$0;

        private Receiver(ReplicatedCharacter replicatedCharacter) {
            ReplicatedCharacter replicatedCharacter2 = replicatedCharacter;
            Objects.requireNonNull(replicatedCharacter2);
            this.this$0 = replicatedCharacter2;
        }

        @Override
        public void run() {
            CharacterItemBuf buf = CharacterBuf.buffer();
            try {
                while (true) {
                    char newvalue;
                    char oldvalue;
                    this.this$0.myComm.floodReceive(this.this$0.myTag, buf);
                    while (!this.this$0.myValue.compareAndSet(oldvalue = (char)this.this$0.myValue.get(), newvalue = this.this$0.myOp.op(oldvalue, buf.item))) {
                    }
                }
            }
            catch (Throwable exc) {
                exc.printStackTrace(System.err);
                return;
            }
        }
    }
}

