/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.ShortOp;
import java.util.concurrent.atomic.AtomicIntegerArray;

public class SharedShortArray {
    private AtomicIntegerArray myArray;

    public SharedShortArray(int len) {
        this.myArray = new AtomicIntegerArray(len);
    }

    public SharedShortArray(short[] array) {
        int n = array.length;
        int[] intarray = new int[n];
        for (int i = 0; i < n; ++i) {
            intarray[i] = array[i];
        }
        this.myArray = new AtomicIntegerArray(intarray);
    }

    public int length() {
        return this.myArray.length();
    }

    public short get(int i) {
        return (short)this.myArray.get(i);
    }

    public void set(int i, short value) {
        this.myArray.set(i, value);
    }

    public short getAndSet(int i, short value) {
        return (short)this.myArray.getAndSet(i, value);
    }

    public boolean compareAndSet(int i, short expect, short update) {
        return this.myArray.compareAndSet(i, expect, update);
    }

    public boolean weakCompareAndSet(int i, short expect, short update) {
        return this.myArray.weakCompareAndSet(i, expect, update);
    }

    public short getAndIncrement(int i) {
        short newvalue;
        short oldvalue;
        while (!this.myArray.compareAndSet(i, oldvalue = (short)this.myArray.get(i), newvalue = (short)(oldvalue + 1))) {
        }
        return oldvalue;
    }

    public short getAndDecrement(int i) {
        short newvalue;
        short oldvalue;
        while (!this.myArray.compareAndSet(i, oldvalue = (short)this.myArray.get(i), newvalue = (short)(oldvalue - 1))) {
        }
        return oldvalue;
    }

    public short getAndAdd(int i, short value) {
        short newvalue;
        short oldvalue;
        while (!this.myArray.compareAndSet(i, oldvalue = (short)this.myArray.get(i), newvalue = (short)(oldvalue + value))) {
        }
        return oldvalue;
    }

    public short incrementAndGet(int i) {
        short newvalue;
        short oldvalue;
        while (!this.myArray.compareAndSet(i, oldvalue = (short)this.myArray.get(i), newvalue = (short)(oldvalue + 1))) {
        }
        return newvalue;
    }

    public short decrementAndGet(int i) {
        short newvalue;
        short oldvalue;
        while (!this.myArray.compareAndSet(i, oldvalue = (short)this.myArray.get(i), newvalue = (short)(oldvalue - 1))) {
        }
        return newvalue;
    }

    public short addAndGet(int i, short value) {
        short newvalue;
        short oldvalue;
        while (!this.myArray.compareAndSet(i, oldvalue = (short)this.myArray.get(i), newvalue = (short)(oldvalue + value))) {
        }
        return newvalue;
    }

    public short reduce(int i, short value, ShortOp op) {
        short newvalue;
        short oldvalue;
        while (!this.myArray.compareAndSet(i, oldvalue = (short)this.myArray.get(i), newvalue = op.op(oldvalue, value))) {
        }
        return newvalue;
    }

    public void reduce(short[] src, ShortOp op) {
        this.reduce(0, src, 0, this.myArray.length(), op);
    }

    public void reduce(int dstoff, short[] src, int srcoff, int len, ShortOp op) {
        if (len < 0 || dstoff < 0 || dstoff + len > this.myArray.length() || srcoff < 0 || srcoff + len > src.length) {
            throw new IndexOutOfBoundsException();
        }
        while (len > 0) {
            short newvalue;
            short oldvalue;
            while (!this.myArray.compareAndSet(dstoff, oldvalue = (short)this.myArray.get(dstoff), newvalue = op.op(oldvalue, src[srcoff]))) {
            }
            ++dstoff;
            ++srcoff;
            --len;
        }
    }

    public String toString() {
        return this.myArray.toString();
    }
}

