/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.LongOp;
import java.util.concurrent.atomic.AtomicLongArray;

public class SharedLongMatrix {
    private AtomicLongArray[] myMatrix;

    public SharedLongMatrix(int rows, int cols) {
        this.myMatrix = new AtomicLongArray[rows];
        for (int r = 0; r < rows; ++r) {
            this.myMatrix[r] = new AtomicLongArray(cols);
        }
    }

    public SharedLongMatrix(long[][] matrix) {
        this.myMatrix = new AtomicLongArray[matrix.length];
        for (int r = 0; r < matrix.length; ++r) {
            this.myMatrix[r] = new AtomicLongArray(matrix[r]);
        }
    }

    public int rows() {
        return this.myMatrix.length;
    }

    public int cols() {
        return this.myMatrix[0].length();
    }

    public long get(int r, int c) {
        return this.myMatrix[r].get(c);
    }

    public void set(int r, int c, long value) {
        this.myMatrix[r].set(c, value);
    }

    public long getAndSet(int r, int c, long value) {
        return this.myMatrix[r].getAndSet(c, value);
    }

    public boolean compareAndSet(int r, int c, long expect, long update) {
        return this.myMatrix[r].compareAndSet(c, expect, update);
    }

    public boolean weakCompareAndSet(int r, int c, long expect, long update) {
        return this.myMatrix[r].weakCompareAndSet(c, expect, update);
    }

    public long getAndIncrement(int r, int c) {
        return this.myMatrix[r].getAndIncrement(c);
    }

    public long getAndDecrement(int r, int c) {
        return this.myMatrix[r].getAndDecrement(c);
    }

    public long getAndAdd(int r, int c, long value) {
        return this.myMatrix[r].getAndAdd(c, value);
    }

    public long incrementAndGet(int r, int c) {
        return this.myMatrix[r].incrementAndGet(c);
    }

    public long decrementAndGet(int r, int c) {
        return this.myMatrix[r].decrementAndGet(c);
    }

    public long addAndGet(int r, int c, long value) {
        return this.myMatrix[r].addAndGet(c, value);
    }

    public long reduce(int r, int c, long value, LongOp op) {
        long newvalue;
        long oldvalue;
        AtomicLongArray myMatrix_r = this.myMatrix[r];
        while (!myMatrix_r.compareAndSet(c, oldvalue = myMatrix_r.get(c), newvalue = op.op(oldvalue, value))) {
        }
        return newvalue;
    }

    public void reduce(long[][] src, LongOp op) {
        this.reduce(0, 0, src, 0, 0, this.rows(), this.cols(), op);
    }

    public void reduce(int dstrow, int dstcol, long[][] src, int srcrow, int srccol, int rowlen, int collen, LongOp op) {
        if (rowlen < 0 || collen < 0 || dstrow < 0 || dstrow + rowlen > this.rows() || dstcol < 0 || dstcol + collen > this.cols() || srcrow < 0 || srcrow + rowlen > src.length || srccol < 0 || srccol + collen > src[0].length) {
            throw new IndexOutOfBoundsException();
        }
        for (int r = 0; r < rowlen; ++r) {
            AtomicLongArray myMatrix_r = this.myMatrix[dstrow + r];
            long[] src_r = src[srcrow + r];
            for (int c = 0; c < collen; ++c) {
                long newvalue;
                long oldvalue;
                int dstcol_c = dstcol + c;
                long src_r_c = src_r[srccol + c];
                while (!myMatrix_r.compareAndSet(dstcol_c, oldvalue = myMatrix_r.get(dstcol_c), newvalue = op.op(oldvalue, src_r_c))) {
                }
            }
        }
    }
}

