/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.IntegerOp;
import java.util.concurrent.atomic.AtomicIntegerArray;

public class SharedIntegerMatrix {
    private AtomicIntegerArray[] myMatrix;

    public SharedIntegerMatrix(int rows, int cols) {
        this.myMatrix = new AtomicIntegerArray[rows];
        for (int r = 0; r < rows; ++r) {
            this.myMatrix[r] = new AtomicIntegerArray(cols);
        }
    }

    public SharedIntegerMatrix(int[][] matrix) {
        this.myMatrix = new AtomicIntegerArray[matrix.length];
        for (int r = 0; r < matrix.length; ++r) {
            this.myMatrix[r] = new AtomicIntegerArray(matrix[r]);
        }
    }

    public int rows() {
        return this.myMatrix.length;
    }

    public int cols() {
        return this.myMatrix[0].length();
    }

    public int get(int r, int c) {
        return this.myMatrix[r].get(c);
    }

    public void set(int r, int c, int value) {
        this.myMatrix[r].set(c, value);
    }

    public int getAndSet(int r, int c, int value) {
        return this.myMatrix[r].getAndSet(c, value);
    }

    public boolean compareAndSet(int r, int c, int expect, int update) {
        return this.myMatrix[r].compareAndSet(c, expect, update);
    }

    public boolean weakCompareAndSet(int r, int c, int expect, int update) {
        return this.myMatrix[r].weakCompareAndSet(c, expect, update);
    }

    public int getAndIncrement(int r, int c) {
        return this.myMatrix[r].getAndIncrement(c);
    }

    public int getAndDecrement(int r, int c) {
        return this.myMatrix[r].getAndDecrement(c);
    }

    public int getAndAdd(int r, int c, int value) {
        return this.myMatrix[r].getAndAdd(c, value);
    }

    public int incrementAndGet(int r, int c) {
        return this.myMatrix[r].incrementAndGet(c);
    }

    public int decrementAndGet(int r, int c) {
        return this.myMatrix[r].decrementAndGet(c);
    }

    public int addAndGet(int r, int c, int value) {
        return this.myMatrix[r].addAndGet(c, value);
    }

    public int reduce(int r, int c, int value, IntegerOp op) {
        int newvalue;
        int oldvalue;
        AtomicIntegerArray myMatrix_r = this.myMatrix[r];
        while (!myMatrix_r.compareAndSet(c, oldvalue = myMatrix_r.get(c), newvalue = op.op(oldvalue, value))) {
        }
        return newvalue;
    }

    public void reduce(int[][] src, IntegerOp op) {
        this.reduce(0, 0, src, 0, 0, this.rows(), this.cols(), op);
    }

    public void reduce(int dstrow, int dstcol, int[][] src, int srcrow, int srccol, int rowlen, int collen, IntegerOp op) {
        if (rowlen < 0 || collen < 0 || dstrow < 0 || dstrow + rowlen > this.rows() || dstcol < 0 || dstcol + collen > this.cols() || srcrow < 0 || srcrow + rowlen > src.length || srccol < 0 || srccol + collen > src[0].length) {
            throw new IndexOutOfBoundsException();
        }
        for (int r = 0; r < rowlen; ++r) {
            AtomicIntegerArray myMatrix_r = this.myMatrix[dstrow + r];
            int[] src_r = src[srcrow + r];
            for (int c = 0; c < collen; ++c) {
                int newvalue;
                int oldvalue;
                int dstcol_c = dstcol + c;
                int src_r_c = src_r[srccol + c];
                while (!myMatrix_r.compareAndSet(dstcol_c, oldvalue = myMatrix_r.get(dstcol_c), newvalue = op.op(oldvalue, src_r_c))) {
                }
            }
        }
    }
}

