/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.IntegerOp;
import java.util.concurrent.atomic.AtomicIntegerArray;

public class SharedIntegerArray {
    private AtomicIntegerArray myArray;

    public SharedIntegerArray(int len) {
        this.myArray = new AtomicIntegerArray(len);
    }

    public SharedIntegerArray(int[] array) {
        this.myArray = new AtomicIntegerArray(array);
    }

    public int length() {
        return this.myArray.length();
    }

    public int get(int i) {
        return this.myArray.get(i);
    }

    public void set(int i, int value) {
        this.myArray.set(i, value);
    }

    public int getAndSet(int i, int value) {
        return this.myArray.getAndSet(i, value);
    }

    public boolean compareAndSet(int i, int expect, int update) {
        return this.myArray.compareAndSet(i, expect, update);
    }

    public boolean weakCompareAndSet(int i, int expect, int update) {
        return this.myArray.weakCompareAndSet(i, expect, update);
    }

    public int getAndIncrement(int i) {
        return this.myArray.getAndIncrement(i);
    }

    public int getAndDecrement(int i) {
        return this.myArray.getAndDecrement(i);
    }

    public int getAndAdd(int i, int value) {
        return this.myArray.getAndAdd(i, value);
    }

    public int incrementAndGet(int i) {
        return this.myArray.incrementAndGet(i);
    }

    public int decrementAndGet(int i) {
        return this.myArray.decrementAndGet(i);
    }

    public int addAndGet(int i, int value) {
        return this.myArray.addAndGet(i, value);
    }

    public int reduce(int i, int value, IntegerOp op) {
        int newvalue;
        int oldvalue;
        while (!this.myArray.compareAndSet(i, oldvalue = this.myArray.get(i), newvalue = op.op(oldvalue, value))) {
        }
        return newvalue;
    }

    public void reduce(int[] src, IntegerOp op) {
        this.reduce(0, src, 0, this.myArray.length(), op);
    }

    public void reduce(int dstoff, int[] src, int srcoff, int len, IntegerOp op) {
        if (len < 0 || dstoff < 0 || dstoff + len > this.myArray.length() || srcoff < 0 || srcoff + len > src.length) {
            throw new IndexOutOfBoundsException();
        }
        while (len > 0) {
            int newvalue;
            int oldvalue;
            while (!this.myArray.compareAndSet(dstoff, oldvalue = this.myArray.get(dstoff), newvalue = op.op(oldvalue, src[srcoff]))) {
            }
            ++dstoff;
            ++srcoff;
            --len;
        }
    }

    public String toString() {
        return this.myArray.toString();
    }
}

