/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.DoubleOp;
import java.util.concurrent.atomic.AtomicLong;

public class SharedDouble
extends Number {
    private static final long serialVersionUID = 1L;
    private AtomicLong myValue;

    public SharedDouble() {
        this.myValue = new AtomicLong(Double.doubleToLongBits(0.0));
    }

    public SharedDouble(double initialValue) {
        this.myValue = new AtomicLong(Double.doubleToLongBits(initialValue));
    }

    public double get() {
        return Double.longBitsToDouble(this.myValue.get());
    }

    public void set(double value) {
        this.myValue.set(Double.doubleToLongBits(value));
    }

    public double getAndSet(double value) {
        return Double.longBitsToDouble(this.myValue.getAndSet(Double.doubleToLongBits(value)));
    }

    public boolean compareAndSet(double expect, double update) {
        return this.myValue.compareAndSet(Double.doubleToLongBits(expect), Double.doubleToLongBits(update));
    }

    public boolean weakCompareAndSet(double expect, double update) {
        return this.myValue.weakCompareAndSet(Double.doubleToLongBits(expect), Double.doubleToLongBits(update));
    }

    public double getAndIncrement() {
        double oldvalue;
        double newvalue;
        long newvalueLong;
        long oldvalueLong;
        while (!this.myValue.compareAndSet(oldvalueLong = this.myValue.get(), newvalueLong = Double.doubleToLongBits(newvalue = (oldvalue = Double.longBitsToDouble(oldvalueLong)) + 1.0))) {
        }
        return oldvalue;
    }

    public double getAndDecrement() {
        double oldvalue;
        double newvalue;
        long newvalueLong;
        long oldvalueLong;
        while (!this.myValue.compareAndSet(oldvalueLong = this.myValue.get(), newvalueLong = Double.doubleToLongBits(newvalue = (oldvalue = Double.longBitsToDouble(oldvalueLong)) - 1.0))) {
        }
        return oldvalue;
    }

    public double getAndAdd(double value) {
        double oldvalue;
        double newvalue;
        long newvalueLong;
        long oldvalueLong;
        while (!this.myValue.compareAndSet(oldvalueLong = this.myValue.get(), newvalueLong = Double.doubleToLongBits(newvalue = (oldvalue = Double.longBitsToDouble(oldvalueLong)) + value))) {
        }
        return oldvalue;
    }

    public double incrementAndGet() {
        double oldvalue;
        double newvalue;
        long newvalueLong;
        long oldvalueLong;
        while (!this.myValue.compareAndSet(oldvalueLong = this.myValue.get(), newvalueLong = Double.doubleToLongBits(newvalue = (oldvalue = Double.longBitsToDouble(oldvalueLong)) + 1.0))) {
        }
        return newvalue;
    }

    public double decrementAndGet() {
        double oldvalue;
        double newvalue;
        long newvalueLong;
        long oldvalueLong;
        while (!this.myValue.compareAndSet(oldvalueLong = this.myValue.get(), newvalueLong = Double.doubleToLongBits(newvalue = (oldvalue = Double.longBitsToDouble(oldvalueLong)) - 1.0))) {
        }
        return newvalue;
    }

    public double addAndGet(double value) {
        double oldvalue;
        double newvalue;
        long newvalueLong;
        long oldvalueLong;
        while (!this.myValue.compareAndSet(oldvalueLong = this.myValue.get(), newvalueLong = Double.doubleToLongBits(newvalue = (oldvalue = Double.longBitsToDouble(oldvalueLong)) + value))) {
        }
        return newvalue;
    }

    public double reduce(double value, DoubleOp op) {
        double oldvalue;
        double newvalue;
        long newvalueLong;
        long oldvalueLong;
        while (!this.myValue.compareAndSet(oldvalueLong = this.myValue.get(), newvalueLong = Double.doubleToLongBits(newvalue = op.op(oldvalue = Double.longBitsToDouble(oldvalueLong), value)))) {
        }
        return newvalue;
    }

    public String toString() {
        return Double.toString(this.get());
    }

    @Override
    public int intValue() {
        return (int)this.get();
    }

    @Override
    public long longValue() {
        return (long)this.get();
    }

    @Override
    public float floatValue() {
        return (float)this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }
}

