/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.CharacterOp;
import java.util.concurrent.atomic.AtomicInteger;

public class SharedCharacter
extends Number {
    private static final long serialVersionUID = 1L;
    private AtomicInteger myValue;

    public SharedCharacter() {
        this.myValue = new AtomicInteger();
    }

    public SharedCharacter(char initialValue) {
        this.myValue = new AtomicInteger(initialValue);
    }

    public char get() {
        return (char)this.myValue.get();
    }

    public void set(char value) {
        this.myValue.set(value);
    }

    public char getAndSet(char value) {
        return (char)this.myValue.getAndSet(value);
    }

    public boolean compareAndSet(char expect, char update) {
        return this.myValue.compareAndSet(expect, update);
    }

    public boolean weakCompareAndSet(char expect, char update) {
        return this.myValue.weakCompareAndSet(expect, update);
    }

    public char getAndIncrement() {
        char newvalue;
        char oldvalue;
        while (!this.myValue.compareAndSet(oldvalue = (char)this.myValue.get(), newvalue = (char)(oldvalue + '\u0001'))) {
        }
        return oldvalue;
    }

    public char getAndDecrement() {
        char newvalue;
        char oldvalue;
        while (!this.myValue.compareAndSet(oldvalue = (char)this.myValue.get(), newvalue = (char)(oldvalue - '\u0001'))) {
        }
        return oldvalue;
    }

    public char getAndAdd(char value) {
        char newvalue;
        char oldvalue;
        while (!this.myValue.compareAndSet(oldvalue = (char)this.myValue.get(), newvalue = (char)(oldvalue + value))) {
        }
        return oldvalue;
    }

    public char incrementAndGet() {
        char newvalue;
        char oldvalue;
        while (!this.myValue.compareAndSet(oldvalue = (char)this.myValue.get(), newvalue = (char)(oldvalue + '\u0001'))) {
        }
        return newvalue;
    }

    public char decrementAndGet() {
        char newvalue;
        char oldvalue;
        while (!this.myValue.compareAndSet(oldvalue = (char)this.myValue.get(), newvalue = (char)(oldvalue - '\u0001'))) {
        }
        return newvalue;
    }

    public char addAndGet(char value) {
        char newvalue;
        char oldvalue;
        while (!this.myValue.compareAndSet(oldvalue = (char)this.myValue.get(), newvalue = (char)(oldvalue + value))) {
        }
        return newvalue;
    }

    public char reduce(char value, CharacterOp op) {
        char newvalue;
        char oldvalue;
        while (!this.myValue.compareAndSet(oldvalue = (char)this.myValue.get(), newvalue = op.op(oldvalue, value))) {
        }
        return newvalue;
    }

    public String toString() {
        return Character.toString(this.get());
    }

    @Override
    public int intValue() {
        return this.get();
    }

    @Override
    public long longValue() {
        return this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }
}

