/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.ByteOp;
import java.util.concurrent.atomic.AtomicIntegerArray;

public class SharedByteArray {
    private AtomicIntegerArray myArray;

    public SharedByteArray(int len) {
        this.myArray = new AtomicIntegerArray(len);
    }

    public SharedByteArray(byte[] array) {
        int n = array.length;
        int[] intarray = new int[n];
        for (int i = 0; i < n; ++i) {
            intarray[i] = array[i];
        }
        this.myArray = new AtomicIntegerArray(intarray);
    }

    public int length() {
        return this.myArray.length();
    }

    public byte get(int i) {
        return (byte)this.myArray.get(i);
    }

    public void set(int i, byte value) {
        this.myArray.set(i, value);
    }

    public byte getAndSet(int i, byte value) {
        return (byte)this.myArray.getAndSet(i, value);
    }

    public boolean compareAndSet(int i, byte expect, byte update) {
        return this.myArray.compareAndSet(i, expect, update);
    }

    public boolean weakCompareAndSet(int i, byte expect, byte update) {
        return this.myArray.weakCompareAndSet(i, expect, update);
    }

    public byte getAndIncrement(int i) {
        byte newvalue;
        byte oldvalue;
        while (!this.myArray.compareAndSet(i, oldvalue = (byte)this.myArray.get(i), newvalue = (byte)(oldvalue + 1))) {
        }
        return oldvalue;
    }

    public byte getAndDecrement(int i) {
        byte newvalue;
        byte oldvalue;
        while (!this.myArray.compareAndSet(i, oldvalue = (byte)this.myArray.get(i), newvalue = (byte)(oldvalue - 1))) {
        }
        return oldvalue;
    }

    public byte getAndAdd(int i, byte value) {
        byte newvalue;
        byte oldvalue;
        while (!this.myArray.compareAndSet(i, oldvalue = (byte)this.myArray.get(i), newvalue = (byte)(oldvalue + value))) {
        }
        return oldvalue;
    }

    public byte incrementAndGet(int i) {
        byte newvalue;
        byte oldvalue;
        while (!this.myArray.compareAndSet(i, oldvalue = (byte)this.myArray.get(i), newvalue = (byte)(oldvalue + 1))) {
        }
        return newvalue;
    }

    public byte decrementAndGet(int i) {
        byte newvalue;
        byte oldvalue;
        while (!this.myArray.compareAndSet(i, oldvalue = (byte)this.myArray.get(i), newvalue = (byte)(oldvalue - 1))) {
        }
        return newvalue;
    }

    public byte addAndGet(int i, byte value) {
        byte newvalue;
        byte oldvalue;
        while (!this.myArray.compareAndSet(i, oldvalue = (byte)this.myArray.get(i), newvalue = (byte)(oldvalue + value))) {
        }
        return newvalue;
    }

    public byte reduce(int i, byte value, ByteOp op) {
        byte newvalue;
        byte oldvalue;
        while (!this.myArray.compareAndSet(i, oldvalue = (byte)this.myArray.get(i), newvalue = op.op(oldvalue, value))) {
        }
        return newvalue;
    }

    public void reduce(byte[] src, ByteOp op) {
        this.reduce(0, src, 0, this.myArray.length(), op);
    }

    public void reduce(int dstoff, byte[] src, int srcoff, int len, ByteOp op) {
        if (len < 0 || dstoff < 0 || dstoff + len > this.myArray.length() || srcoff < 0 || srcoff + len > src.length) {
            throw new IndexOutOfBoundsException();
        }
        while (len > 0) {
            byte newvalue;
            byte oldvalue;
            while (!this.myArray.compareAndSet(dstoff, oldvalue = (byte)this.myArray.get(dstoff), newvalue = op.op(oldvalue, src[srcoff]))) {
            }
            ++dstoff;
            ++srcoff;
            --len;
        }
    }

    public String toString() {
        return this.myArray.toString();
    }
}

