/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.BooleanOp;
import java.util.concurrent.atomic.AtomicIntegerArray;

public class SharedBooleanArray {
    private AtomicIntegerArray myArray;

    public SharedBooleanArray(int len) {
        this.myArray = new AtomicIntegerArray(len);
    }

    public SharedBooleanArray(boolean[] array) {
        int n = array.length;
        int[] intarray = new int[n];
        for (int i = 0; i < n; ++i) {
            intarray[i] = array[i] ? 1 : 0;
        }
        this.myArray = new AtomicIntegerArray(intarray);
    }

    public int length() {
        return this.myArray.length();
    }

    public boolean get(int i) {
        return this.myArray.get(i) != 0;
    }

    public void set(int i, boolean value) {
        this.myArray.set(i, value ? 1 : 0);
    }

    public boolean getAndSet(int i, boolean value) {
        return this.myArray.getAndSet(i, value ? 1 : 0) != 0;
    }

    public boolean compareAndSet(int i, boolean expect, boolean update) {
        return this.myArray.compareAndSet(i, expect ? 1 : 0, update ? 1 : 0);
    }

    public boolean weakCompareAndSet(int i, boolean expect, boolean update) {
        return this.myArray.weakCompareAndSet(i, expect ? 1 : 0, update ? 1 : 0);
    }

    public boolean reduce(int i, boolean value, BooleanOp op) {
        int newvalue;
        int oldvalue;
        while (!this.myArray.compareAndSet(i, oldvalue, newvalue = op.op((oldvalue = this.myArray.get(i)) != 0, value) ? 1 : 0)) {
        }
        return newvalue != 0;
    }

    public void reduce(boolean[] src, BooleanOp op) {
        this.reduce(0, src, 0, this.myArray.length(), op);
    }

    public void reduce(int dstoff, boolean[] src, int srcoff, int len, BooleanOp op) {
        if (len < 0 || dstoff < 0 || dstoff + len > this.myArray.length() || srcoff < 0 || srcoff + len > src.length) {
            throw new IndexOutOfBoundsException();
        }
        while (len > 0) {
            int newvalue;
            int oldvalue;
            while (!this.myArray.compareAndSet(dstoff, oldvalue, newvalue = op.op((oldvalue = this.myArray.get(dstoff)) != 0, src[srcoff]) ? 1 : 0)) {
            }
            ++dstoff;
            ++srcoff;
            --len;
        }
    }

    public String toString() {
        return this.myArray.toString();
    }
}

