/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import edu.rit.http.HttpRequest;
import edu.rit.http.HttpResponse;
import edu.rit.http.HttpServer;
import edu.rit.mp.Channel;
import edu.rit.mp.ChannelGroup;
import edu.rit.mp.ChannelGroupClosedException;
import edu.rit.mp.ConnectListener;
import edu.rit.mp.ObjectBuf;
import edu.rit.mp.Status;
import edu.rit.mp.buf.ObjectItemBuf;
import edu.rit.pj.cluster.BackendInfo;
import edu.rit.pj.cluster.Configuration;
import edu.rit.pj.cluster.Constants;
import edu.rit.pj.cluster.JobFrontendProxy;
import edu.rit.pj.cluster.JobFrontendRef;
import edu.rit.pj.cluster.JobInfo;
import edu.rit.pj.cluster.JobSchedulerMessage;
import edu.rit.pj.cluster.JobSchedulerRef;
import edu.rit.util.Logger;
import edu.rit.util.PrintStreamLogger;
import edu.rit.util.Timer;
import edu.rit.util.TimerTask;
import edu.rit.util.TimerThread;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class JobScheduler
implements JobSchedulerRef {
    private String myClusterName;
    private Logger myLog;
    private String myWebHost;
    private int myWebPort;
    private String mySchedulerHost;
    private int mySchedulerPort;
    private String myFrontendHost;
    private int myJobTime;
    private Map<String, BackendInfo> myNameToBackendMap = new HashMap<String, BackendInfo>();
    private BackendInfo[] myBackendInfo;
    private int myBackendCount;
    private int myNextBackendNumber = 0;
    private int myNextJobNumber = 1;
    private Map<JobFrontendRef, JobInfo> myFrontendToJobMap = new HashMap<JobFrontendRef, JobInfo>();
    private List<JobInfo> myRunningJobList = new LinkedList<JobInfo>();
    private List<JobInfo> myWaitingJobList = new LinkedList<JobInfo>();
    private TimerThread myLeaseTimerThread;
    private ChannelGroup myChannelGroup;
    private HttpServer myHttpServer;
    private long myTotalComputeTime;
    private long myStartDateTime;

    private JobScheduler(String configfile) throws IOException {
        long now;
        this.myStartDateTime = now = System.currentTimeMillis();
        Configuration config = new Configuration(configfile);
        this.myClusterName = config.getClusterName();
        this.myLog = new PrintStreamLogger(new PrintStream(new FileOutputStream(config.getLogFile(), true), true));
        this.myWebHost = config.getWebHost();
        this.myWebPort = config.getWebPort();
        this.mySchedulerHost = config.getSchedulerHost();
        this.mySchedulerPort = config.getSchedulerPort();
        this.myFrontendHost = config.getFrontendHost();
        this.myJobTime = config.getJobTime();
        this.myBackendCount = config.getBackendCount();
        this.myBackendInfo = new BackendInfo[this.myBackendCount];
        for (int i = 0; i < this.myBackendCount; ++i) {
            BackendInfo backendinfo = config.getBackendInfo(i);
            this.myNameToBackendMap.put(backendinfo.name, backendinfo);
            this.myBackendInfo[i] = backendinfo;
        }
        this.myLog.log(now, "Started Parallel Java v20120620");
        Runtime.getRuntime().addShutdownHook(new Thread(this){
            final /* synthetic */ JobScheduler this$0;
            {
                JobScheduler jobScheduler = this$0;
                Objects.requireNonNull(jobScheduler);
                this.this$0 = jobScheduler;
            }

            @Override
            public void run() {
                this.this$0.shutdown();
            }
        });
        this.myLeaseTimerThread = new TimerThread();
        this.myLeaseTimerThread.setDaemon(true);
        this.myLeaseTimerThread.start();
        this.myChannelGroup = new ChannelGroup(new InetSocketAddress(this.mySchedulerHost, this.mySchedulerPort), this.myLog);
        this.myLog.log(now, "Job Scheduler at " + String.valueOf(this.myChannelGroup.listenAddress()));
        this.myChannelGroup.setConnectListener(new ConnectListener(this){
            final /* synthetic */ JobScheduler this$0;
            {
                JobScheduler jobScheduler = this$0;
                Objects.requireNonNull(jobScheduler);
                this.this$0 = jobScheduler;
            }

            @Override
            public void nearEndConnected(ChannelGroup theChannelGroup, Channel theChannel) {
            }

            @Override
            public void farEndConnected(ChannelGroup theChannelGroup, Channel theChannel) {
                this.this$0.createJob(theChannel);
            }
        });
        this.myHttpServer = new HttpServer(this, new InetSocketAddress(this.myWebHost, this.myWebPort), this.myLog){
            final /* synthetic */ JobScheduler this$0;
            {
                JobScheduler jobScheduler = this$0;
                Objects.requireNonNull(jobScheduler);
                this.this$0 = jobScheduler;
                super(address, logger);
            }

            @Override
            protected void process(HttpRequest request, HttpResponse response) throws IOException {
                this.this$0.processHttpRequest(request, response);
            }
        };
        this.myLog.log(now, "Web interface at " + String.valueOf(this.myHttpServer.getAddress()));
        for (BackendInfo backend : this.myBackendInfo) {
            this.myLog.log(now, "Backend " + backend.name + " at " + backend.host + ", " + backend.totalCpus + " CPU" + (backend.totalCpus == 1 ? "" : "s"));
        }
        this.myChannelGroup.startListening();
    }

    private synchronized void createJob(Channel theChannel) {
        JobFrontendProxy frontend = new JobFrontendProxy(this.myChannelGroup, theChannel);
        theChannel.info(frontend);
        JobInfo jobinfo = this.getJobInfo(frontend);
        jobinfo.renewTimer.start(Constants.LEASE_RENEW_INTERVAL, Constants.LEASE_RENEW_INTERVAL);
        jobinfo.expireTimer.start(Constants.LEASE_EXPIRE_INTERVAL);
    }

    private void run() {
        ObjectItemBuf<JobSchedulerMessage> buf = ObjectBuf.buffer((JobSchedulerMessage)null);
        Status status = null;
        JobSchedulerMessage message = null;
        JobFrontendRef frontend = null;
        while (true) {
            try {
                status = this.myChannelGroup.receive(null, null, buf);
            }
            catch (ChannelGroupClosedException exc) {
                break;
            }
            catch (Throwable exc) {
                this.myLog.log("Exception while receiving message", exc);
                break;
            }
            message = (JobSchedulerMessage)buf.item;
            frontend = (JobFrontendRef)status.channel.info();
            try {
                message.invoke(this, frontend);
            }
            catch (Throwable exc) {
                this.myLog.log("Exception while processing message", exc);
            }
            buf.item = null;
            status = null;
            message = null;
            frontend = null;
        }
    }

    @Override
    public synchronized void backendFailed(JobFrontendRef theJobFrontend, String name) throws IOException {
        BackendInfo backendinfo = this.myNameToBackendMap.get(name);
        if (backendinfo != null) {
            long now = System.currentTimeMillis();
            this.myLog.log(now, "Backend " + name + " failed");
        }
    }

    @Override
    public synchronized void cancelJob(JobFrontendRef theJobFrontend, String errmsg) throws IOException {
        JobInfo jobinfo = this.getJobInfo(theJobFrontend);
        this.doCancelJob(System.currentTimeMillis(), jobinfo, errmsg);
    }

    @Override
    public synchronized void jobFinished(JobFrontendRef theJobFrontend) throws IOException {
        JobInfo jobinfo = this.getJobInfo(theJobFrontend);
        this.doFinishJob(System.currentTimeMillis(), jobinfo);
    }

    @Override
    public synchronized void renewLease(JobFrontendRef theJobFrontend) throws IOException {
        JobInfo jobinfo = this.getJobInfo(theJobFrontend);
        jobinfo.expireTimer.start(Constants.LEASE_EXPIRE_INTERVAL);
    }

    @Override
    public synchronized void reportComment(JobFrontendRef theJobFrontend, int rank, String comment) {
        JobInfo jobinfo = this.getJobInfo(theJobFrontend);
        jobinfo.comment[rank] = comment;
    }

    @Override
    public synchronized void requestJob(JobFrontendRef theJobFrontend, String username, int Nn, int Np, int Nt) throws IOException {
        JobInfo jobinfo = this.getJobInfo(theJobFrontend);
        long now = System.currentTimeMillis();
        this.myLog.log(now, "Job " + jobinfo.jobnum + " queued, username=" + username + ", nn=" + Nn + ", np=" + Np + ", nt=" + Nt);
        jobinfo.username = username;
        jobinfo.Nn = Math.min(Nn, Np);
        jobinfo.Np = Np;
        jobinfo.Nt = Nt;
        jobinfo.backend = new BackendInfo[Np];
        jobinfo.cpus = new int[Np];
        jobinfo.comment = new String[Np];
        for (int i = 0; i < Np; ++i) {
            jobinfo.comment[i] = "";
        }
        if (!this.enoughResourcesForJob(jobinfo.Nn, jobinfo.Np, jobinfo.Nt)) {
            this.doCancelJobTooFewResources(now, jobinfo);
            return;
        }
        this.myWaitingJobList.add(jobinfo);
        theJobFrontend.assignJobNumber(this, jobinfo.jobnum, this.myFrontendHost);
        this.assignResourcesToJobs(now);
    }

    @Override
    public void close() {
    }

    private synchronized void renewTimeout(Timer theTimer, JobFrontendRef theJobFrontend) throws IOException {
        if (theTimer.isTriggered()) {
            theJobFrontend.renewLease(this);
        }
    }

    private synchronized void expireTimeout(Timer theTimer, JobFrontendRef theJobFrontend) throws IOException {
        if (theTimer.isTriggered()) {
            JobInfo jobinfo = this.getJobInfo(theJobFrontend);
            this.doCancelJob(System.currentTimeMillis(), jobinfo, "Job frontend lease expired");
        }
    }

    private synchronized void jobTimeout(Timer theTimer, JobFrontendRef theJobFrontend) throws IOException {
        if (theTimer.isTriggered()) {
            JobInfo jobinfo = this.getJobInfo(theJobFrontend);
            String errmsg = "Maximum job time (" + this.myJobTime + " seconds) exceeded";
            jobinfo.frontend.cancelJob(this, errmsg);
            this.doCancelJob(System.currentTimeMillis(), jobinfo, errmsg);
        }
    }

    private JobInfo getJobInfo(JobFrontendRef frontend) {
        final JobFrontendRef fe = frontend;
        JobInfo jobinfo = this.myFrontendToJobMap.get(frontend);
        if (jobinfo == null) {
            jobinfo = new JobInfo(this.myNextJobNumber++, JobInfo.State.WAITING, System.currentTimeMillis(), null, 0, 0, 0, 0, null, null, 0, fe, this.myLeaseTimerThread.createTimer(new TimerTask(){
                final /* synthetic */ JobScheduler this$0;
                {
                    JobScheduler jobScheduler = this$0;
                    Objects.requireNonNull(jobScheduler);
                    this.this$0 = jobScheduler;
                }

                @Override
                public void action(Timer theTimer) {
                    try {
                        this.this$0.renewTimeout(theTimer, fe);
                    }
                    catch (Throwable exc) {
                        this.this$0.myLog.log(exc);
                    }
                }
            }), this.myLeaseTimerThread.createTimer(new TimerTask(){
                final /* synthetic */ JobScheduler this$0;
                {
                    JobScheduler jobScheduler = this$0;
                    Objects.requireNonNull(jobScheduler);
                    this.this$0 = jobScheduler;
                }

                @Override
                public void action(Timer theTimer) {
                    try {
                        this.this$0.expireTimeout(theTimer, fe);
                    }
                    catch (Throwable exc) {
                        this.this$0.myLog.log(exc);
                    }
                }
            }), this.myLeaseTimerThread.createTimer(new TimerTask(){
                final /* synthetic */ JobScheduler this$0;
                {
                    JobScheduler jobScheduler = this$0;
                    Objects.requireNonNull(jobScheduler);
                    this.this$0 = jobScheduler;
                }

                @Override
                public void action(Timer theTimer) {
                    try {
                        this.this$0.jobTimeout(theTimer, fe);
                    }
                    catch (Throwable exc) {
                        this.this$0.myLog.log(exc);
                    }
                }
            }));
            this.myFrontendToJobMap.put(frontend, jobinfo);
        }
        return jobinfo;
    }

    private void doFinishJob(long now, JobInfo jobinfo) throws IOException {
        this.myLog.log(now, "Job " + jobinfo.jobnum + " finished");
        this.doCleanupJob(now, jobinfo);
    }

    private void doCancelJob(long now, JobInfo jobinfo, String errmsg) throws IOException {
        this.myLog.log(now, "Job " + jobinfo.jobnum + " canceled: " + errmsg);
        this.doCleanupJob(now, jobinfo);
    }

    private void doCancelJobTooFewResources(long now, JobInfo jobinfo) throws IOException {
        String errmsg = jobinfo.Nt == 0 ? "Too few resources available to assign " + jobinfo.Nn + " node" + (jobinfo.Nn == 1 ? "" : "s") + " and " + jobinfo.Np + " process" + (jobinfo.Np == 1 ? "" : "es") : "Too few resources available to assign " + jobinfo.Nn + " node" + (jobinfo.Nn == 1 ? "" : "s") + ", " + jobinfo.Np + " process" + (jobinfo.Np == 1 ? "" : "es") + ", and " + jobinfo.Nt + " CPU" + (jobinfo.Nt == 1 ? "" : "s") + " per process";
        jobinfo.frontend.cancelJob(this, errmsg);
        this.doCancelJob(now, jobinfo, errmsg);
    }

    private void doCleanupJob(long now, JobInfo jobinfo) throws IOException {
        jobinfo.renewTimer.stop();
        jobinfo.expireTimer.stop();
        jobinfo.jobTimer.stop();
        jobinfo.frontend.close();
        this.myFrontendToJobMap.remove(jobinfo.frontend);
        this.myRunningJobList.remove(jobinfo);
        this.myWaitingJobList.remove(jobinfo);
        for (int i = 0; i < jobinfo.count; ++i) {
            BackendInfo backendinfo = jobinfo.backend[i];
            if (backendinfo.state == BackendInfo.State.FAILED) continue;
            backendinfo.state = BackendInfo.State.IDLE;
            backendinfo.stateTime = now;
            backendinfo.job = null;
        }
        this.myTotalComputeTime += now - jobinfo.stateTime;
        this.assignResourcesToJobs(now);
    }

    private void assignResourcesToJobs(long now) throws IOException {
        LinkedList<JobInfo> cancelList = new LinkedList<JobInfo>();
        Iterator<JobInfo> iter = this.myWaitingJobList.iterator();
        while (iter.hasNext()) {
            JobInfo jobinfo = iter.next();
            if (!this.enoughResourcesForJob(jobinfo.Nn, jobinfo.Np, jobinfo.Nt)) {
                iter.remove();
                cancelList.add(jobinfo);
                continue;
            }
            int Np_div_Nn = jobinfo.Np / jobinfo.Nn;
            int Np_rem_Nn = jobinfo.Np % jobinfo.Nn;
            int be = this.myNextBackendNumber;
            do {
                int Nproc = Np_div_Nn;
                if (jobinfo.nodeCount < Np_rem_Nn) {
                    ++Nproc;
                }
                BackendInfo backendinfo = this.myBackendInfo[be];
                if (backendinfo.state != BackendInfo.State.IDLE || backendinfo.totalCpus < Nproc) continue;
                backendinfo.state = BackendInfo.State.RESERVED;
                backendinfo.stateTime = now;
                backendinfo.job = jobinfo;
                int Nt_div_Nproc = backendinfo.totalCpus / Nproc;
                int Nt_rem_Nproc = backendinfo.totalCpus % Nproc;
                for (int i = 0; i < Nproc; ++i) {
                    int Ncpus = jobinfo.Nt;
                    if (Ncpus == 0) {
                        Ncpus = Nt_div_Nproc;
                        if (i < Nt_rem_Nproc) {
                            ++Ncpus;
                        }
                    }
                    this.myLog.log(now, "Job " + jobinfo.jobnum + " assigned " + backendinfo.name + ", rank=" + jobinfo.count + ", CPUs=" + Ncpus);
                    jobinfo.backend[jobinfo.count] = backendinfo;
                    jobinfo.cpus[jobinfo.count] = Ncpus;
                    ++jobinfo.count;
                    jobinfo.frontend.assignBackend(this, backendinfo.name, backendinfo.host, backendinfo.jvm, backendinfo.classpath, backendinfo.jvmflags, backendinfo.shellCommand, Ncpus);
                }
                ++jobinfo.nodeCount;
            } while ((be = (be + 1) % this.myBackendCount) != this.myNextBackendNumber && jobinfo.count < jobinfo.Np);
            this.myNextBackendNumber = be;
            if (jobinfo.count != jobinfo.Np) break;
            this.myLog.log(now, "Job " + jobinfo.jobnum + " started");
            iter.remove();
            this.myRunningJobList.add(jobinfo);
            jobinfo.state = JobInfo.State.RUNNING;
            jobinfo.stateTime = now;
            for (BackendInfo backendinfo : jobinfo.backend) {
                backendinfo.state = BackendInfo.State.RUNNING;
                backendinfo.stateTime = now;
            }
            if (this.myJobTime <= 0) continue;
            jobinfo.jobTimer.start((long)this.myJobTime * 1000L);
        }
        for (JobInfo jobinfo : cancelList) {
            this.doCancelJobTooFewResources(now, jobinfo);
        }
    }

    private boolean enoughResourcesForJob(int Nn, int Np, int Nt) {
        int Ppn = (Np + Nn - 1) / Nn;
        if (Nt == 0) {
            Nt = 1;
        }
        int nodeCount = 0;
        for (BackendInfo backendinfo : this.myBackendInfo) {
            if (backendinfo.state == BackendInfo.State.FAILED || backendinfo.totalCpus < Ppn * Nt) continue;
            ++nodeCount;
        }
        return nodeCount >= Nn;
    }

    private void processHttpRequest(HttpRequest request, HttpResponse response) throws IOException {
        long now = System.currentTimeMillis();
        if (!request.isValid()) {
            response.setStatusCode(HttpResponse.Status.STATUS_400_BAD_REQUEST);
            PrintWriter out = response.getPrintWriter();
            this.printStatusHtmlStart(out, now);
            out.println("<P>");
            out.println("400 Bad Request");
            this.printStatusHtmlEnd(out);
        } else if (!request.getMethod().equals("GET")) {
            response.setStatusCode(HttpResponse.Status.STATUS_501_NOT_IMPLEMENTED);
            PrintWriter out = response.getPrintWriter();
            this.printStatusHtmlStart(out, now);
            out.println("<P>");
            out.println("501 Not Implemented");
            this.printStatusHtmlEnd(out);
        } else if (request.getUri().equals("/") || request.getUri().equals("/?")) {
            PrintWriter out = response.getPrintWriter();
            this.printStatusHtmlStart(out, now);
            this.printStatusHtmlBody(out, now);
            this.printStatusHtmlEnd(out);
        } else if (request.getUri().equals("/debug")) {
            PrintWriter out = response.getPrintWriter();
            this.printDebugHtmlStart(out, now);
            this.printDebugHtmlBody(out);
            this.printStatusHtmlEnd(out);
        } else if (request.getUri().startsWith("/job/")) {
            String jobString = request.getUri().substring(5);
            try {
                int jobNum = Integer.parseInt(jobString);
                PrintWriter out = response.getPrintWriter();
                this.printJobDetailHtmlStart(out, now, jobNum);
                this.printJobDetailHtmlBody(out, now, jobNum);
                this.printStatusHtmlEnd(out);
            }
            catch (NumberFormatException exc) {
                PrintWriter out = response.getPrintWriter();
                this.printErrorHtmlStart(out);
                out.printf("<P>Invalid job number \"%s\"</P>\n", jobString);
                this.printErrorHtmlEnd(out);
            }
        } else {
            response.setStatusCode(HttpResponse.Status.STATUS_404_NOT_FOUND);
            PrintWriter out = response.getPrintWriter();
            this.printErrorHtmlStart(out);
            out.println("<P>404 Not Found</P>");
            this.printErrorHtmlEnd(out);
        }
        response.close();
    }

    private void printStatusHtmlStart(PrintWriter out, long now) {
        out.println("<HTML>");
        out.println("<HEAD>");
        out.print("<TITLE>");
        out.print(this.myClusterName);
        out.println("</TITLE>");
        out.print("<META HTTP-EQUIV=\"refresh\" CONTENT=\"20;url=");
        this.printWebInterfaceURL(out);
        out.println("\">");
        out.println("<STYLE TYPE=\"text/css\">");
        out.println("<!--");
        out.println("* {font-family: Arial, Helvetica, Sans-Serif;}");
        out.println("body {font-size: small;}");
        out.println("h1 {font-size: 140%; font-weight: bold;}");
        out.println("table {font-size: 100%;}");
        out.println("-->");
        out.println("</STYLE>");
        out.println("</HEAD>");
        out.println("<BODY>");
        out.print("<H1>");
        out.print(this.myClusterName);
        out.println("</H1>");
        out.println("<P>");
        out.print("<FORM ACTION=\"");
        this.printWebInterfaceURL(out);
        out.println("\" METHOD=\"get\">");
        out.println("<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0>");
        out.println("<TR>");
        out.print("<TD ALIGN=\"left\" VALIGN=\"center\">");
        out.print("<INPUT TYPE=\"submit\" VALUE=\"Refresh\">");
        out.println("</TD>");
        out.println("<TD WIDTH=20> </TD>");
        out.print("<TD ALIGN=\"left\" VALIGN=\"center\">");
        out.print(new Date(now));
        out.print(" -- ");
        out.print("Parallel Java v20120620");
        out.println("</TD>");
        out.println("</TR>");
        out.println("</TABLE>");
        out.println("</FORM>");
    }

    private synchronized void printStatusHtmlBody(PrintWriter out, long now) {
        out.println("<P>");
        out.println("<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0>");
        out.println("<TR>");
        out.println("<TD ALIGN=\"center\" VALIGN=\"top\">");
        out.println("Nodes");
        out.println("<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0>");
        out.println("<TR>");
        out.println("<TD ALIGN=\"left\" VALIGN=\"top\">");
        out.println("<TABLE BORDER=0 CELLPADDING=3 CELLSPACING=0>");
        this.printBackendLabels(out);
        int i = 0;
        for (BackendInfo backend : this.myBackendInfo) {
            this.printBackendInfo(out, now, backend, i);
            ++i;
        }
        out.println("</TABLE>");
        out.println("</TD>");
        out.println("</TR>");
        out.println("</TABLE>");
        out.println("</TD>");
        out.println("<TD WIDTH=40> </TD>");
        out.println("<TD ALIGN=\"center\" VALIGN=\"top\">");
        out.println("Jobs");
        out.println("<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0>");
        out.println("<TR>");
        out.println("<TD ALIGN=\"left\" VALIGN=\"top\">");
        out.println("<TABLE BORDER=0 CELLPADDING=3 CELLSPACING=0>");
        this.printJobLabels(out);
        i = 0;
        for (JobInfo job : this.myRunningJobList) {
            this.printJobInfo(out, now, job, i);
            ++i;
        }
        for (JobInfo job : this.myWaitingJobList) {
            this.printJobInfo(out, now, job, i);
            ++i;
        }
        out.println("</TABLE>");
        out.println("</TD>");
        out.println("</TR>");
        out.println("</TABLE>");
        this.printTotalComputeTime(out);
        out.print("<BR>");
        this.printJobCount(out);
        out.println("<BR>Since " + String.valueOf(new Date(this.myStartDateTime)));
        out.println("</TD>");
        out.println("</TR>");
        out.println("</TABLE>");
    }

    private void printJobCount(PrintWriter out) {
        if (this.myNextJobNumber == 2) {
            out.print("1 job");
        } else {
            out.print(this.myNextJobNumber - 1);
            out.print(" jobs");
        }
        out.println(" served");
    }

    private void printTotalComputeTime(PrintWriter out) {
        if (this.myTotalComputeTime < 1000000L) {
            out.print(this.myTotalComputeTime / 1000L);
        } else if (this.myTotalComputeTime < 1000000000L) {
            out.print("Over ");
            out.print(this.myTotalComputeTime / 1000000L);
            out.print(" thousand");
        } else if (this.myTotalComputeTime < 1000000000000L) {
            out.print("Over ");
            out.print(this.myTotalComputeTime / 1000000000L);
            out.print(" million");
        } else if (this.myTotalComputeTime < 1000000000000000L) {
            out.print("Over ");
            out.print(this.myTotalComputeTime / 1000000000000L);
            out.print(" billion");
        } else {
            out.print("Over ");
            out.print(this.myTotalComputeTime / 1000000000000000L);
            out.print(" trillion");
        }
        out.println(" CPU seconds served");
    }

    private void printStatusHtmlEnd(PrintWriter out) {
        out.println("<P>");
        out.println("<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0>");
        out.println("<TR>");
        out.println("<TD ALIGN=\"left\" VALIGN=\"top\">");
        out.println("Job queue web interface:&nbsp;&nbsp;");
        out.println("</TD>");
        out.println("<TD ALIGN=\"left\" VALIGN=\"top\">");
        out.print("<A HREF=\"");
        this.printWebInterfaceURL(out);
        out.print("\">");
        this.printWebInterfaceURL(out);
        out.println("</A>");
        out.println("</TD>");
        out.println("</TR>");
        out.println("<TR>");
        out.println("<TD ALIGN=\"left\" VALIGN=\"top\">");
        out.println("Powered by Parallel Java:&nbsp;&nbsp;");
        out.println("</TD>");
        out.println("<TD ALIGN=\"left\" VALIGN=\"top\">");
        out.println("<A HREF=\"http://www.cs.rit.edu/~ark/pj.shtml\">http://www.cs.rit.edu/~ark/pj.shtml</A>");
        out.println("</TD>");
        out.println("</TR>");
        out.println("<TR>");
        out.println("<TD ALIGN=\"left\" VALIGN=\"top\">");
        out.println("Developed by Alan Kaminsky:&nbsp;&nbsp;");
        out.println("</TD>");
        out.println("<TD ALIGN=\"left\" VALIGN=\"top\">");
        out.println("<A HREF=\"http://www.cs.rit.edu/~ark/\">http://www.cs.rit.edu/~ark/</A>");
        out.println("</TD>");
        out.println("</TR>");
        out.println("</TABLE>");
        out.println("</BODY>");
        out.println("</HTML>");
    }

    private void printWebInterfaceURL(PrintWriter out) {
        out.printf("http://%s:%d/", this.myWebHost, this.myWebPort);
    }

    private void printJobNumberURL(PrintWriter out, int jobNum) {
        out.printf("http://%s:%d/job/%d", this.myWebHost, this.myWebPort, jobNum);
    }

    private void printJobNumberLink(PrintWriter out, int jobNum) {
        out.printf("<A HREF=\"http://%s:%d/job/%d\">&nbsp;%d&nbsp;</A>", this.myWebHost, this.myWebPort, jobNum, jobNum);
    }

    private void printDeltaTime(PrintWriter out, long now, long then) {
        out.print((now - then + 500L) / 1000L);
        out.print(" sec");
    }

    private void printBackendLabels(PrintWriter out) {
        out.println("<TR BGCOLOR=\"#E8E8E8\">");
        out.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        out.print("<I>Node</I>");
        out.println("</TD>");
        out.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        out.print("<I>CPUs</I>");
        out.println("</TD>");
        out.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        out.print("<I>Status</I>");
        out.println("</TD>");
        out.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        out.print("<I>Job</I>");
        out.println("</TD>");
        out.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        out.print("<I>Time</I>");
        out.println("</TD>");
        out.println("</TR>");
    }

    private void printBackendInfo(PrintWriter out, long now, BackendInfo backend, int i) {
        out.print("<TR BGCOLOR=\"#");
        out.print(i % 2 == 0 ? "FFFFFF" : "E8E8E8");
        out.println("\">");
        out.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        out.print(backend.name);
        out.println("</TD>");
        out.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        out.print(backend.totalCpus);
        out.println("</TD>");
        out.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        if (backend.state == BackendInfo.State.FAILED) {
            out.print("<FONT COLOR=\"#FF0000\"><B>");
            out.print((Object)backend.state);
            out.print("</B></FONT>");
        } else {
            out.print((Object)backend.state);
        }
        out.println("</TD>");
        out.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        if (backend.job != null) {
            this.printJobNumberLink(out, backend.job.jobnum);
        } else {
            out.print("&nbsp;");
        }
        out.println("</TD>");
        out.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        if (backend.job != null) {
            this.printDeltaTime(out, now, backend.job.stateTime);
        } else {
            out.print("&nbsp;");
        }
        out.println("</TD>");
        out.println("</TR>");
    }

    private void printJobLabels(PrintWriter out) {
        out.println("<TR BGCOLOR=\"#E8E8E8\">");
        out.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        out.print("<I>Job</I>");
        out.println("</TD>");
        out.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        out.print("<I>User</I>");
        out.println("</TD>");
        out.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        out.print("<I>nn</I>");
        out.println("</TD>");
        out.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        out.print("<I>np</I>");
        out.println("</TD>");
        out.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        out.print("<I>nt</I>");
        out.println("</TD>");
        out.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        out.print("<I>Rank</I>");
        out.println("</TD>");
        out.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        out.print("<I>Node</I>");
        out.println("</TD>");
        out.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        out.print("<I>CPUs</I>");
        out.println("</TD>");
        out.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        out.print("<I>Status</I>");
        out.println("</TD>");
        out.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        out.print("<I>Time</I>");
        out.println("</TD>");
        out.println("</TR>");
    }

    private void printJobInfo(PrintWriter out, long now, JobInfo job, int i) {
        int j;
        out.print("<TR BGCOLOR=\"#");
        out.print(i % 2 == 0 ? "FFFFFF" : "E8E8E8");
        out.println("\">");
        out.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        this.printJobNumberLink(out, job.jobnum);
        out.println("</TD>");
        out.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        out.print(job.username);
        out.println("</TD>");
        out.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        out.print(job.Nn);
        out.println("</TD>");
        out.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        out.print(job.Np);
        out.println("</TD>");
        out.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        out.print((String)(job.Nt == 0 ? "all" : "" + job.Nt));
        out.println("</TD>");
        out.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        if (job.count == 0) {
            out.print("&nbsp;");
        } else {
            for (j = 0; j < job.count; ++j) {
                if (j > 0) {
                    out.print("<BR>");
                }
                out.print(j);
            }
        }
        out.println("</TD>");
        out.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        if (job.count == 0) {
            out.print("&nbsp;");
        } else {
            for (j = 0; j < job.count; ++j) {
                if (j > 0) {
                    out.print("<BR>");
                }
                out.print(job.backend[j].name);
            }
        }
        out.println("</TD>");
        out.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        if (job.count == 0) {
            out.print("&nbsp;");
        } else {
            for (j = 0; j < job.count; ++j) {
                if (j > 0) {
                    out.print("<BR>");
                }
                out.print(job.cpus[j]);
            }
        }
        out.println("</TD>");
        out.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        out.print((Object)job.state);
        out.println("</TD>");
        out.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        this.printDeltaTime(out, now, job.stateTime);
        out.println("</TD>");
        out.println("</TR>");
    }

    private void printDebugHtmlStart(PrintWriter out, long now) {
        out.println("<HTML>");
        out.println("<HEAD>");
        out.print("<TITLE>");
        out.print(this.myClusterName);
        out.println("</TITLE>");
        out.println("<STYLE TYPE=\"text/css\">");
        out.println("<!--");
        out.println("* {font-family: Arial, Helvetica, Sans-Serif;}");
        out.println("body {font-size: small;}");
        out.println("h1 {font-size: 140%; font-weight: bold;}");
        out.println("table {font-size: 100%;}");
        out.println("-->");
        out.println("</STYLE>");
        out.println("</HEAD>");
        out.println("<BODY>");
        out.print("<H1>");
        out.print(this.myClusterName);
        out.println("</H1>");
        out.println("<P>");
        out.print(new Date(now));
        out.print(" -- ");
        out.print("Parallel Java v20120620");
        out.println("</P>");
    }

    private void printDebugHtmlBody(PrintWriter out) {
        out.println("<P>");
        out.println("<HR/>");
        out.println("<H3>Thread Dump</H3>");
        out.println("</P>");
        Map<Thread, StackTraceElement[]> traces = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : traces.entrySet()) {
            Thread thread = entry.getKey();
            out.println("<P>");
            out.print("Name: ");
            out.print(thread.getName());
            out.println("&nbsp;&nbsp;&nbsp;&nbsp;");
            out.print(" Daemon: ");
            out.print(thread.isDaemon() ? "yes" : "no");
            out.println("&nbsp;&nbsp;&nbsp;&nbsp;");
            out.print(" State: ");
            out.print((Object)thread.getState());
            out.println("&nbsp;&nbsp;&nbsp;&nbsp;");
            out.print(" Priority: ");
            out.print(thread.getPriority());
            out.println("&nbsp;&nbsp;&nbsp;&nbsp;");
            out.print(" Thread Group: ");
            out.print(thread.getThreadGroup().getName());
            out.println();
            for (StackTraceElement element : entry.getValue()) {
                out.print("<BR/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                out.println(element);
            }
            out.println("</P>");
        }
        out.println("<P>");
        out.println("<HR/>");
        out.println("</P>");
    }

    private void printJobDetailHtmlStart(PrintWriter out, long now, int jobNum) {
        out.println("<HTML>");
        out.println("<HEAD>");
        out.print("<TITLE>");
        out.print(this.myClusterName);
        out.println("</TITLE>");
        out.print("<META HTTP-EQUIV=\"refresh\" CONTENT=\"20;url=");
        this.printJobNumberURL(out, jobNum);
        out.println("\">");
        out.println("<STYLE TYPE=\"text/css\">");
        out.println("<!--");
        out.println("* {font-family: Arial, Helvetica, Sans-Serif;}");
        out.println("body {font-size: small;}");
        out.println("h1 {font-size: 140%; font-weight: bold;}");
        out.println("table {font-size: 100%;}");
        out.println("-->");
        out.println("</STYLE>");
        out.println("</HEAD>");
        out.println("<BODY>");
        out.print("<H1>");
        out.print(this.myClusterName);
        out.println("</H1>");
        out.println("<P>");
        out.print("<FORM ACTION=\"");
        this.printJobNumberURL(out, jobNum);
        out.println("\" METHOD=\"get\">");
        out.println("<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0>");
        out.println("<TR>");
        out.print("<TD ALIGN=\"left\" VALIGN=\"center\">");
        out.print("<INPUT TYPE=\"submit\" VALUE=\"Refresh\">");
        out.println("</TD>");
        out.println("<TD WIDTH=20> </TD>");
        out.print("<TD ALIGN=\"left\" VALIGN=\"center\">");
        out.print(new Date(now));
        out.print(" -- ");
        out.print("Parallel Java v20120620");
        out.println("</TD>");
        out.println("</TR>");
        out.println("</TABLE>");
        out.println("</FORM>");
    }

    private synchronized void printJobDetailHtmlBody(PrintWriter out, long now, int jobNum) {
        JobInfo jobInfo = null;
        for (JobInfo job : this.myRunningJobList) {
            if (job.jobnum != jobNum) continue;
            jobInfo = job;
            break;
        }
        if (jobInfo == null) {
            for (JobInfo job : this.myWaitingJobList) {
                if (job.jobnum != jobNum) continue;
                jobInfo = job;
                break;
            }
        }
        out.println("<P>");
        out.println("<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0>");
        out.println("<TR>");
        out.println("<TD ALIGN=\"left\" VALIGN=\"top\"><B>Job:</B></TD>");
        out.println("<TD WIDTH=10> </TD>");
        out.printf("<TD ALIGN=\"left\" VALIGN=\"top\"><B>%d</B></TD>", jobNum);
        out.println("</TR>");
        out.println("<TR>");
        out.println("<TD ALIGN=\"left\" VALIGN=\"top\">User:</TD>");
        out.println("<TD WIDTH=10> </TD>");
        out.printf("<TD ALIGN=\"left\" VALIGN=\"top\">%s</TD>", jobInfo == null ? " " : jobInfo.username);
        out.println("</TR>");
        out.println("<TR>");
        out.println("<TD ALIGN=\"left\" VALIGN=\"top\">Nodes (nn):</TD>");
        out.println("<TD WIDTH=10> </TD>");
        out.printf("<TD ALIGN=\"left\" VALIGN=\"top\">%s</TD>", jobInfo == null ? " " : "" + jobInfo.Nn);
        out.println("</TR>");
        out.println("<TR>");
        out.println("<TD ALIGN=\"left\" VALIGN=\"top\">Processes (np):</TD>");
        out.println("<TD WIDTH=10> </TD>");
        out.printf("<TD ALIGN=\"left\" VALIGN=\"top\">%s</TD>", jobInfo == null ? " " : "" + jobInfo.Np);
        out.println("</TR>");
        out.println("<TR>");
        out.println("<TD ALIGN=\"left\" VALIGN=\"top\">Threads (nt):</TD>");
        out.println("<TD WIDTH=10> </TD>");
        out.printf("<TD ALIGN=\"left\" VALIGN=\"top\">%s</TD>", jobInfo == null ? " " : (jobInfo.Nt == 0 ? "All" : "" + jobInfo.Nt));
        out.println("</TR>");
        out.println("<TR>");
        out.println("<TD ALIGN=\"left\" VALIGN=\"top\">Status:</TD>");
        out.println("<TD WIDTH=10> </TD>");
        out.printf("<TD ALIGN=\"left\" VALIGN=\"top\">%s</TD>", jobInfo == null ? "Not in queue" : jobInfo.state);
        out.println("</TR>");
        out.println("<TR>");
        out.println("<TD ALIGN=\"left\" VALIGN=\"top\">Time:</TD>");
        out.println("<TD WIDTH=10> </TD>");
        out.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        if (jobInfo == null) {
            out.print(" ");
        } else {
            this.printDeltaTime(out, now, jobInfo.stateTime);
        }
        out.println("</TD>");
        out.println("</TR>");
        out.println("</TABLE>");
        out.println("</P>");
        if (jobInfo == null || jobInfo.count == 0) {
            return;
        }
        out.println("<P>");
        out.println("<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0>");
        out.println("<TR>");
        out.println("<TD ALIGN=\"center\" VALIGN=\"top\">");
        out.println("Processes");
        out.println("<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0>");
        out.println("<TR>");
        out.println("<TD ALIGN=\"left\" VALIGN=\"top\">");
        out.println("<TABLE BORDER=0 CELLPADDING=3 CELLSPACING=0>");
        this.printJobDetailProcessLabels(out);
        for (int i = 0; i < jobInfo.count; ++i) {
            this.printJobDetailProcessInfo(out, jobInfo, i);
        }
        out.println("</TABLE>");
        out.println("</TD>");
        out.println("</TR>");
        out.println("</TABLE>");
        out.println("</TD>");
        out.println("</TR>");
        out.println("</TABLE>");
        out.println("</P>");
    }

    private void printJobDetailProcessLabels(PrintWriter out) {
        out.println("<TR BGCOLOR=\"#E8E8E8\">");
        out.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        out.print("<I>Rank</I>");
        out.println("</TD>");
        out.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        out.print("<I>Node</I>");
        out.println("</TD>");
        out.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        out.print("<I>CPUs</I>");
        out.println("</TD>");
        out.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        out.print("<I>Comment</I>");
        out.println("</TD>");
        out.println("</TR>");
    }

    private void printJobDetailProcessInfo(PrintWriter out, JobInfo jobInfo, int rank) {
        out.printf("<TR BGCOLOR=\"#%s\">\n", rank % 2 == 0 ? "FFFFFF" : "E8E8E8");
        out.printf("<TD ALIGN=\"left\" VALIGN=\"top\">%d&nbsp;&nbsp;</TD>\n", rank);
        out.printf("<TD ALIGN=\"left\" VALIGN=\"top\">%s&nbsp;&nbsp;</TD>\n", jobInfo.backend[rank].name);
        out.printf("<TD ALIGN=\"left\" VALIGN=\"top\">%d&nbsp;&nbsp;</TD>\n", jobInfo.cpus[rank]);
        out.printf("<TD ALIGN=\"left\" VALIGN=\"top\">%s</TD>\n", jobInfo.comment[rank]);
        out.println("</TR>");
    }

    private void printErrorHtmlStart(PrintWriter out) {
        out.println("<HTML>");
        out.println("<HEAD>");
        out.print("<TITLE>");
        out.print(this.myClusterName);
        out.println("</TITLE>");
        out.println("<STYLE TYPE=\"text/css\">");
        out.println("<!--");
        out.println("* {font-family: Arial, Helvetica, Sans-Serif;}");
        out.println("body {font-size: small;}");
        out.println("h1 {font-size: 140%; font-weight: bold;}");
        out.println("table {font-size: 100%;}");
        out.println("-->");
        out.println("</STYLE>");
        out.println("</HEAD>");
        out.println("<BODY>");
    }

    private void printErrorHtmlEnd(PrintWriter out) {
        out.println("</BODY>");
        out.println("</HTML>");
    }

    private void shutdown() {
        if (this.myChannelGroup != null) {
            this.myChannelGroup.close();
        }
        if (this.myHttpServer != null) {
            try {
                this.myHttpServer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.myLog.log("Stopped");
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: java edu.rit.pj.cluster.JobScheduler <configfile>");
            System.exit(1);
        }
        JobScheduler scheduler = new JobScheduler(args[0]);
        scheduler.run();
    }
}

