/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import edu.rit.mp.ByteBuf;
import edu.rit.mp.Channel;
import edu.rit.mp.ChannelGroup;
import edu.rit.pj.cluster.JobBackendRef;
import edu.rit.pj.cluster.JobFrontendMessage;
import edu.rit.pj.cluster.JobFrontendRef;
import edu.rit.pj.cluster.JobSchedulerRef;
import edu.rit.pj.cluster.Proxy;
import edu.rit.util.Range;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;

public class JobFrontendProxy
extends Proxy
implements JobFrontendRef {
    public JobFrontendProxy(ChannelGroup theChannelGroup, Channel theChannel) {
        super(theChannelGroup, theChannel);
    }

    @Override
    public void assignBackend(JobSchedulerRef theJobScheduler, String name, String host, String jvm, String classpath, String[] jvmflags, String shellCommand, int Nt) throws IOException {
        this.send(JobFrontendMessage.assignBackend(theJobScheduler, name, host, jvm, classpath, jvmflags, shellCommand, Nt));
    }

    @Override
    public void assignJobNumber(JobSchedulerRef theJobScheduler, int jobnum, String pjhost) throws IOException {
        this.send(JobFrontendMessage.assignJobNumber(theJobScheduler, jobnum, pjhost));
    }

    @Override
    public void cancelJob(JobSchedulerRef theJobScheduler, String errmsg) throws IOException {
        this.send(JobFrontendMessage.cancelJob(theJobScheduler, errmsg));
    }

    @Override
    public void renewLease(JobSchedulerRef theJobScheduler) throws IOException {
        this.send(JobFrontendMessage.renewLease(theJobScheduler));
    }

    @Override
    public void backendFinished(JobBackendRef theJobBackend) throws IOException {
        this.send(JobFrontendMessage.backendFinished(theJobBackend));
    }

    @Override
    public void backendReady(JobBackendRef theJobBackend, int rank, InetSocketAddress middlewareAddress, InetSocketAddress worldAddress, InetSocketAddress frontendAddress) throws IOException {
        this.send(JobFrontendMessage.backendReady(theJobBackend, rank, middlewareAddress, worldAddress, frontendAddress));
    }

    @Override
    public void cancelJob(JobBackendRef theJobBackend, String errmsg) throws IOException {
        this.send(JobFrontendMessage.cancelJob(theJobBackend, errmsg));
    }

    @Override
    public void renewLease(JobBackendRef theJobBackend) throws IOException {
        this.send(JobFrontendMessage.renewLease(theJobBackend));
    }

    @Override
    public void requestResource(JobBackendRef theJobBackend, String resourceName) throws IOException {
        this.send(JobFrontendMessage.requestResource(theJobBackend, resourceName));
    }

    @Override
    public void outputFileOpen(JobBackendRef theJobBackend, int bfd, File file, boolean append) throws IOException {
        this.send(JobFrontendMessage.outputFileOpen(theJobBackend, bfd, file, append));
    }

    @Override
    public void outputFileWrite(JobBackendRef theJobBackend, int ffd, byte[] buf, int off, int len) throws IOException {
        this.send(JobFrontendMessage.outputFileWrite(theJobBackend, ffd, len));
        this.send(ffd, ByteBuf.sliceBuffer(buf, new Range(off, off + len - 1)));
    }

    @Override
    public void outputFileFlush(JobBackendRef theJobBackend, int ffd) throws IOException {
        this.send(JobFrontendMessage.outputFileFlush(theJobBackend, ffd));
    }

    @Override
    public void outputFileClose(JobBackendRef theJobBackend, int ffd) throws IOException {
        this.send(JobFrontendMessage.outputFileClose(theJobBackend, ffd));
    }

    @Override
    public void inputFileOpen(JobBackendRef theJobBackend, int bfd, File file) throws IOException {
        this.send(JobFrontendMessage.inputFileOpen(theJobBackend, bfd, file));
    }

    @Override
    public void inputFileRead(JobBackendRef theJobBackend, int ffd, int len) throws IOException {
        this.send(JobFrontendMessage.inputFileRead(theJobBackend, ffd, len));
    }

    @Override
    public void inputFileSkip(JobBackendRef theJobBackend, int ffd, long len) throws IOException {
        this.send(JobFrontendMessage.inputFileSkip(theJobBackend, ffd, len));
    }

    @Override
    public void inputFileClose(JobBackendRef theJobBackend, int ffd) throws IOException {
        this.send(JobFrontendMessage.inputFileClose(theJobBackend, ffd));
    }

    @Override
    public void reportComment(JobBackendRef theJobBackend, int rank, String comment) throws IOException {
        this.send(JobFrontendMessage.reportComment(theJobBackend, rank, comment));
    }
}

