/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import edu.rit.mp.Channel;
import edu.rit.mp.ChannelGroup;
import edu.rit.mp.ChannelGroupClosedException;
import edu.rit.mp.ObjectBuf;
import edu.rit.mp.Status;
import edu.rit.mp.buf.ObjectItemBuf;
import edu.rit.pj.PJProperties;
import edu.rit.pj.cluster.Constants;
import edu.rit.pj.cluster.FrontendFileReader;
import edu.rit.pj.cluster.FrontendFileWriter;
import edu.rit.pj.cluster.JobBackendProxy;
import edu.rit.pj.cluster.JobBackendRef;
import edu.rit.pj.cluster.JobFrontendMessage;
import edu.rit.pj.cluster.JobFrontendRef;
import edu.rit.pj.cluster.JobSchedulerException;
import edu.rit.pj.cluster.JobSchedulerProxy;
import edu.rit.pj.cluster.JobSchedulerRef;
import edu.rit.pj.cluster.ProcessInfo;
import edu.rit.pj.cluster.ResourceCache;
import edu.rit.util.ByteSequence;
import edu.rit.util.Timer;
import edu.rit.util.TimerTask;
import edu.rit.util.TimerThread;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JobFrontend
implements Runnable,
JobFrontendRef {
    private static final Logger logger = Logger.getLogger(JobFrontend.class.getName());
    private FileHandler fileHandler = null;
    private String username;
    private int jobnum;
    private int Nn;
    private int Np;
    private int Nt;
    private boolean hasFrontendComm;
    private String myMainClassName;
    private String[] myArgs;
    private int myNextRank;
    private TimerThread myLeaseTimerThread;
    private Timer mySchedulerRenewTimer;
    private Timer mySchedulerExpireTimer;
    private Timer myJobTimer;
    private ProcessInfo[] myProcessInfo;
    private Map<JobBackendRef, ProcessInfo> myProcessMap = new HashMap<JobBackendRef, ProcessInfo>();
    private int myRunningCount;
    private int myFinishedCount;
    private ChannelGroup myMiddlewareChannelGroup;
    private InetSocketAddress[] myMiddlewareAddress;
    private JobSchedulerRef myJobScheduler;
    private InetSocketAddress[] myWorldAddress;
    private ChannelGroup myFrontendChannelGroup;
    private InetSocketAddress[] myFrontendAddress;
    private String userJvmFlags = PJProperties.getPjJvmFlags();
    private ResourceCache myResourceCache = new ResourceCache();
    private boolean continueRun = true;
    private State myState = State.RUNNING;
    private String myCancelMessage = "User canceled job";
    private FrontendFileWriter myFrontendFileWriter;
    private FrontendFileReader myFrontendFileReader;

    public JobFrontend(String username, int Nn, int Np, int Nt, boolean hasFrontendComm, String mainClassName, String[] args) throws IOException {
        this.username = username;
        this.Nn = Nn;
        this.Np = Np;
        this.Nt = Nt;
        this.hasFrontendComm = hasFrontendComm;
        this.myMainClassName = mainClassName;
        this.myArgs = args;
        Runtime.getRuntime().addShutdownHook(new Thread(this){
            final /* synthetic */ JobFrontend this$0;
            {
                JobFrontend jobFrontend = this$0;
                Objects.requireNonNull(jobFrontend);
                this.this$0 = jobFrontend;
            }

            @Override
            public void run() {
                this.this$0.shutdown();
            }
        });
        this.myLeaseTimerThread = new TimerThread();
        this.myLeaseTimerThread.setDaemon(true);
        this.myLeaseTimerThread.start();
        this.mySchedulerRenewTimer = this.myLeaseTimerThread.createTimer(new TimerTask(this){
            final /* synthetic */ JobFrontend this$0;
            {
                JobFrontend jobFrontend = this$0;
                Objects.requireNonNull(jobFrontend);
                this.this$0 = jobFrontend;
            }

            @Override
            public void action(Timer timer) {
                try {
                    this.this$0.schedulerRenewTimeout();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.mySchedulerExpireTimer = this.myLeaseTimerThread.createTimer(new TimerTask(this){
            final /* synthetic */ JobFrontend this$0;
            {
                JobFrontend jobFrontend = this$0;
                Objects.requireNonNull(jobFrontend);
                this.this$0 = jobFrontend;
            }

            @Override
            public void action(Timer timer) {
                try {
                    this.this$0.schedulerExpireTimeout();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.myJobTimer = this.myLeaseTimerThread.createTimer(new TimerTask(this){
            final /* synthetic */ JobFrontend this$0;
            {
                JobFrontend jobFrontend = this$0;
                Objects.requireNonNull(jobFrontend);
                this.this$0 = jobFrontend;
            }

            @Override
            public void action(Timer timer) {
                try {
                    this.this$0.jobTimeout();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.myProcessInfo = new ProcessInfo[Np];
        int i = 0;
        while (i < Np) {
            ProcessInfo processinfo;
            final int rank = i++;
            this.myProcessInfo[rank] = processinfo = new ProcessInfo(ProcessInfo.State.NOT_STARTED, null, rank, null, null, null, null, this.myLeaseTimerThread.createTimer(new TimerTask(){
                final /* synthetic */ JobFrontend this$0;
                {
                    JobFrontend jobFrontend = this$0;
                    Objects.requireNonNull(jobFrontend);
                    this.this$0 = jobFrontend;
                }

                @Override
                public void action(Timer timer) {
                    try {
                        this.this$0.backendRenewTimeout(rank);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }), this.myLeaseTimerThread.createTimer(new TimerTask(){
                final /* synthetic */ JobFrontend this$0;
                {
                    JobFrontend jobFrontend = this$0;
                    Objects.requireNonNull(jobFrontend);
                    this.this$0 = jobFrontend;
                }

                @Override
                public void action(Timer timer) {
                    try {
                        this.this$0.backendExpireTimeout(rank);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }), 0);
        }
        this.myMiddlewareChannelGroup = new ChannelGroup();
        this.myMiddlewareAddress = new InetSocketAddress[Np + 1];
        this.myWorldAddress = new InetSocketAddress[Np];
        if (hasFrontendComm) {
            this.myFrontendChannelGroup = new ChannelGroup();
            this.myFrontendAddress = new InetSocketAddress[Np + 1];
        }
        this.myFrontendFileWriter = new FrontendFileWriter(this);
        this.myFrontendFileReader = new FrontendFileReader(this);
        InetSocketAddress js_address = null;
        Channel js_channel = null;
        try {
            js_address = new InetSocketAddress(PJProperties.getPjHost(), PJProperties.getPjPort());
            js_channel = this.myMiddlewareChannelGroup.connect(js_address);
        }
        catch (IOException exc) {
            throw new JobSchedulerException("JobFrontend(): Cannot contact Job Scheduler Daemon at " + String.valueOf(js_address), exc);
        }
        this.myJobScheduler = new JobSchedulerProxy(this.myMiddlewareChannelGroup, js_channel);
        this.mySchedulerRenewTimer.start(Constants.LEASE_RENEW_INTERVAL, Constants.LEASE_RENEW_INTERVAL);
        this.mySchedulerExpireTimer.start(Constants.LEASE_EXPIRE_INTERVAL);
        this.myJobScheduler.requestJob(this, username, Nn, Np, Nt);
    }

    @Override
    public void run() {
        ObjectItemBuf<JobFrontendMessage> buf = ObjectBuf.buffer((JobFrontendMessage)null);
        Status status = null;
        JobFrontendMessage message = null;
        JobBackendRef backend = null;
        try {
            while (this.continueRun) {
                status = this.myMiddlewareChannelGroup.receive(null, null, buf);
                message = (JobFrontendMessage)buf.item;
                if (status.tag == 4) {
                    message.invoke((JobFrontendRef)this, this.myJobScheduler);
                } else if (status.tag == 1) {
                    backend = (JobBackendRef)status.channel.info();
                    if (backend == null) {
                        backend = new JobBackendProxy(this.myMiddlewareChannelGroup, status.channel);
                        status.channel.info(backend);
                    }
                    message.invoke((JobFrontendRef)this, backend);
                }
                buf.item = null;
                status = null;
                message = null;
                backend = null;
            }
        }
        catch (ChannelGroupClosedException channelGroupClosedException) {
        }
        catch (Throwable exc) {
            this.terminateCancelJob(exc);
        }
        switch (this.myState.ordinal()) {
            case 1: {
                System.exit(1);
                break;
            }
        }
    }

    @Override
    public void assignBackend(JobSchedulerRef theJobScheduler, String name, String host, String jvm, String classpath, String[] jvmflags, String shellCommand, int Nt) throws IOException {
        int rank = this.myNextRank++;
        ProcessInfo processinfo = this.myProcessInfo[rank];
        processinfo.name = name;
        processinfo.Nt = Nt;
        System.err.print(", ");
        System.err.print(name);
        System.err.flush();
        if (this.myNextRank == this.Np) {
            System.err.println();
        }
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            String listenHost = this.myMiddlewareChannelGroup.listenAddress().getHostName();
            if (listenHost.equalsIgnoreCase(host)) {
                ArrayList<String> command = new ArrayList<String>();
                command.add(jvm);
                command.add("-classpath");
                command.add(classpath);
                if (jvmflags != null && jvmflags.length > 0) {
                    command.addAll(Arrays.asList(jvmflags));
                }
                if (this.userJvmFlags != null && !this.userJvmFlags.trim().equalsIgnoreCase("")) {
                    command.add(this.userJvmFlags.trim());
                }
                command.add("edu.rit.pj.cluster.JobBackend");
                command.add(this.username);
                command.add(Integer.toString(this.jobnum));
                command.add(Integer.toString(this.Np));
                command.add(Integer.toString(rank));
                command.add(Boolean.toString(this.hasFrontendComm));
                command.add(this.myMiddlewareChannelGroup.listenAddress().getHostName());
                command.add(Integer.toString(this.myMiddlewareChannelGroup.listenAddress().getPort()));
                command.add(host);
                ProcessBuilder pb = new ProcessBuilder(command);
                String string = System.getProperty("user.dir");
                if (string != null) {
                    pb.directory(new File(string));
                }
                Process process = pb.start();
            } else {
                StringBuilder command = new StringBuilder();
                command.append(shellCommand);
                command.append(" \"");
                String cwd = System.getProperty("user.dir");
                if (cwd != null) {
                    command.append("cd '");
                    command.append(cwd);
                    command.append("'; ");
                }
                command.append("nohup ");
                command.append(jvm);
                command.append(" -classpath '");
                command.append(classpath);
                command.append("'");
                for (String flag : jvmflags) {
                    command.append(" ");
                    command.append(flag);
                }
                command.append(" ");
                command.append(this.userJvmFlags);
                command.append(" edu.rit.pj.cluster.JobBackend '");
                command.append(this.username);
                command.append("' ");
                command.append(this.jobnum);
                command.append(" ");
                command.append(this.Np);
                command.append(" ");
                command.append(rank);
                command.append(" ");
                command.append(this.hasFrontendComm);
                command.append(" '");
                command.append(this.myMiddlewareChannelGroup.listenAddress().getHostName());
                command.append("' ");
                command.append(this.myMiddlewareChannelGroup.listenAddress().getPort());
                command.append(" '");
                command.append(host);
                command.append("' >/dev/null 2>/dev/null &\"");
                Process process = Runtime.getRuntime().exec(new String[]{"ssh", host, command.toString()});
            }
            processinfo.renewTimer.start(Constants.LEASE_RENEW_INTERVAL, Constants.LEASE_RENEW_INTERVAL);
            processinfo.expireTimer.start(Constants.LEASE_EXPIRE_INTERVAL);
        }
        catch (IOException exc) {
            if (this.myNextRank != this.Np) {
                System.err.println();
            }
            System.err.println(" Exception executing SSH command:\n" + String.valueOf(exc));
            logger.log(Level.SEVERE, " Exception executing SSH command:\n" + String.valueOf(exc));
            this.terminateCancelJob(this.backendFailed(processinfo, "SSH command failed"));
        }
    }

    @Override
    public synchronized void assignJobNumber(JobSchedulerRef theJobScheduler, int jobnum, String pjhost) throws IOException {
        this.jobnum = jobnum;
        this.myMiddlewareChannelGroup.listen(new InetSocketAddress(pjhost, 0));
        this.myMiddlewareChannelGroup.startListening();
        this.myMiddlewareAddress[this.Np] = this.myMiddlewareChannelGroup.listenAddress();
        if (this.hasFrontendComm) {
            this.myFrontendChannelGroup.listen(new InetSocketAddress(pjhost, 0));
            this.myFrontendChannelGroup.startListening();
            this.myFrontendAddress[this.Np] = this.myFrontendChannelGroup.listenAddress();
        }
        System.err.print("Job " + jobnum);
        System.err.flush();
    }

    @Override
    public synchronized void cancelJob(JobSchedulerRef theJobScheduler, String errmsg) throws IOException {
        this.terminateCancelJob(errmsg);
    }

    @Override
    public synchronized void renewLease(JobSchedulerRef theJobScheduler) throws IOException {
        this.mySchedulerExpireTimer.start(Constants.LEASE_EXPIRE_INTERVAL);
    }

    @Override
    public synchronized void backendFinished(JobBackendRef theJobBackend) throws IOException {
        ProcessInfo processinfo = this.myProcessMap.get(theJobBackend);
        if (processinfo == null) {
            return;
        }
        if (processinfo.state != ProcessInfo.State.RUNNING) {
            this.terminateCancelJob("Unexpected \"backend finished\" message, rank=" + processinfo.rank);
        }
        processinfo.state = ProcessInfo.State.FINISHED;
        ++this.myFinishedCount;
        if (this.myFinishedCount == this.Np) {
            this.continueRun = false;
            this.myCancelMessage = null;
        }
    }

    @Override
    public synchronized void backendReady(JobBackendRef theJobBackend, int rank, InetSocketAddress middlewareAddress, InetSocketAddress worldAddress, InetSocketAddress frontendAddress) throws IOException {
        if (0 > rank || rank >= this.Np) {
            this.terminateCancelJob("Illegal \"backend ready\" message, rank=" + rank);
        }
        ProcessInfo processinfo = this.myProcessInfo[rank];
        if (processinfo.state != ProcessInfo.State.NOT_STARTED) {
            this.terminateCancelJob("Unexpected \"backend ready\" message, rank=" + rank);
        }
        processinfo.state = ProcessInfo.State.RUNNING;
        processinfo.backend = theJobBackend;
        processinfo.middlewareAddress = middlewareAddress;
        processinfo.worldAddress = worldAddress;
        processinfo.frontendAddress = frontendAddress;
        this.myProcessMap.put(theJobBackend, processinfo);
        this.myMiddlewareAddress[rank] = middlewareAddress;
        this.myWorldAddress[rank] = worldAddress;
        if (this.hasFrontendComm) {
            this.myFrontendAddress[rank] = frontendAddress;
        }
        ++this.myRunningCount;
        if (this.myRunningCount == this.Np) {
            int jobtime = PJProperties.getPjJobTime();
            if (jobtime > 0) {
                this.myJobTimer.start((long)jobtime * 1000L);
            }
            Properties props = System.getProperties();
            for (ProcessInfo info : this.myProcessMap.values()) {
                props.setProperty("pj.nt", "" + info.Nt);
                info.backend.commenceJob(this, this.myMiddlewareAddress, this.myWorldAddress, this.myFrontendAddress, props, this.myMainClassName, this.myArgs);
            }
        }
    }

    @Override
    public synchronized void cancelJob(JobBackendRef theJobBackend, String errmsg) throws IOException {
        this.terminateCancelJob(errmsg);
    }

    @Override
    public synchronized void renewLease(JobBackendRef theJobBackend) throws IOException {
        ProcessInfo processinfo = this.myProcessMap.get(theJobBackend);
        if (processinfo != null) {
            processinfo.expireTimer.start(Constants.LEASE_EXPIRE_INTERVAL);
        }
    }

    @Override
    public synchronized void requestResource(JobBackendRef theJobBackend, String resourceName) throws IOException {
        byte[] content = null;
        if (this.myResourceCache.contains(resourceName)) {
            content = this.myResourceCache.getNoWait(resourceName);
        } else {
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(resourceName);
            if (stream != null) {
                content = new ByteSequence(stream).toByteArray();
            }
            this.myResourceCache.put(resourceName, content);
        }
        theJobBackend.reportResource((JobFrontendRef)this, resourceName, content);
    }

    @Override
    public synchronized void outputFileOpen(JobBackendRef theJobBackend, int bfd, File file, boolean append) throws IOException {
        this.myFrontendFileWriter.outputFileOpen(theJobBackend, bfd, file, append);
    }

    @Override
    public synchronized void outputFileWrite(JobBackendRef theJobBackend, int ffd, byte[] buf, int off, int len) throws IOException {
        this.myFrontendFileWriter.outputFileWrite(theJobBackend, ffd, len);
    }

    @Override
    public synchronized void outputFileFlush(JobBackendRef theJobBackend, int ffd) throws IOException {
        this.myFrontendFileWriter.outputFileFlush(theJobBackend, ffd);
    }

    @Override
    public synchronized void outputFileClose(JobBackendRef theJobBackend, int ffd) throws IOException {
        this.myFrontendFileWriter.outputFileClose(theJobBackend, ffd);
    }

    @Override
    public synchronized void inputFileOpen(JobBackendRef theJobBackend, int bfd, File file) throws IOException {
        this.myFrontendFileReader.inputFileOpen(theJobBackend, bfd, file);
    }

    @Override
    public synchronized void inputFileRead(JobBackendRef theJobBackend, int ffd, int len) throws IOException {
        this.myFrontendFileReader.inputFileRead(theJobBackend, ffd, len);
    }

    @Override
    public synchronized void inputFileSkip(JobBackendRef theJobBackend, int ffd, long len) throws IOException {
        this.myFrontendFileReader.inputFileSkip(theJobBackend, ffd, len);
    }

    @Override
    public synchronized void inputFileClose(JobBackendRef theJobBackend, int ffd) throws IOException {
        this.myFrontendFileReader.inputFileClose(theJobBackend, ffd);
    }

    @Override
    public synchronized void reportComment(JobBackendRef theJobBackend, int rank, String comment) throws IOException {
        this.myJobScheduler.reportComment(this, rank, comment);
    }

    @Override
    public void close() {
    }

    private synchronized void schedulerRenewTimeout() throws IOException {
        if (this.mySchedulerRenewTimer.isTriggered()) {
            this.myJobScheduler.renewLease(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedulerExpireTimeout() throws IOException {
        boolean doExit = false;
        JobFrontend jobFrontend = this;
        synchronized (jobFrontend) {
            if (this.mySchedulerExpireTimer.isTriggered()) {
                this.continueRun = false;
                if (this.myState == State.RUNNING) {
                    this.myState = State.TERMINATE_CANCEL_JOB;
                    this.myCancelMessage = "Job Scheduler failed";
                    System.err.println(this.myCancelMessage);
                    doExit = true;
                }
            }
        }
        if (doExit) {
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jobTimeout() throws IOException {
        boolean doExit = false;
        JobFrontend jobFrontend = this;
        synchronized (jobFrontend) {
            if (this.myJobTimer.isTriggered()) {
                this.continueRun = false;
                if (this.myState == State.RUNNING) {
                    this.myState = State.TERMINATE_CANCEL_JOB;
                    this.myCancelMessage = "Job exceeded maximum running time";
                    System.err.println(this.myCancelMessage);
                    doExit = true;
                }
            }
        }
        if (doExit) {
            System.exit(1);
        }
    }

    private synchronized void backendRenewTimeout(int rank) throws IOException {
        ProcessInfo processinfo = this.myProcessInfo[rank];
        if (processinfo.renewTimer.isTriggered()) {
            processinfo.backend.renewLease(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backendExpireTimeout(int rank) throws IOException {
        boolean doExit = false;
        JobFrontend jobFrontend = this;
        synchronized (jobFrontend) {
            ProcessInfo processinfo = this.myProcessInfo[rank];
            if (processinfo.expireTimer.isTriggered()) {
                String msg = this.backendFailed(processinfo, "Expire Timer Triggered");
                this.continueRun = false;
                if (this.myState == State.RUNNING) {
                    this.myState = State.TERMINATE_CANCEL_JOB;
                    this.myCancelMessage = msg;
                    System.err.println(this.myCancelMessage);
                    doExit = true;
                }
            }
        }
        if (doExit) {
            System.exit(1);
        }
    }

    private String backendFailed(ProcessInfo processinfo, String reason) {
        processinfo.state = ProcessInfo.State.FAILED;
        try {
            this.myJobScheduler.backendFailed(this, processinfo.name);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String message = String.format("Job backend process failed (%s), node %s, rank %d", reason, processinfo.name, processinfo.rank);
        return message;
    }

    private void terminateCancelJob(String msg) {
        this.continueRun = false;
        if (this.myState == State.RUNNING) {
            this.myState = State.TERMINATE_CANCEL_JOB;
            this.myCancelMessage = msg;
            System.err.println(this.myCancelMessage);
        }
    }

    private void terminateCancelJob(Throwable exc) {
        this.continueRun = false;
        if (this.myState == State.RUNNING) {
            this.myCancelMessage = exc.getClass().getName();
            String msg = exc.getMessage();
            if (msg != null) {
                this.myCancelMessage = this.myCancelMessage + ": " + msg;
            }
            System.err.println(this.myCancelMessage);
            exc.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminateCancelJobOther(Throwable exc) {
        boolean doExit = false;
        JobFrontend jobFrontend = this;
        synchronized (jobFrontend) {
            this.continueRun = false;
            if (this.myState == State.RUNNING) {
                this.myCancelMessage = exc.getClass().getName();
                String msg = exc.getMessage();
                if (msg != null) {
                    this.myCancelMessage = this.myCancelMessage + ": " + msg;
                }
                System.err.println(this.myCancelMessage);
                exc.printStackTrace(System.err);
                doExit = true;
            }
        }
        if (doExit) {
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() {
        JobFrontend jobFrontend = this;
        synchronized (jobFrontend) {
            this.mySchedulerRenewTimer.stop();
            this.mySchedulerExpireTimer.stop();
            for (ProcessInfo processinfo : this.myProcessInfo) {
                processinfo.renewTimer.stop();
                processinfo.expireTimer.stop();
            }
            if (this.myState == State.RUNNING && this.myCancelMessage != null) {
                this.myState = State.TERMINATE_CANCEL_JOB;
            }
            switch (this.myState.ordinal()) {
                case 0: {
                    for (ProcessInfo processinfo : this.myProcessInfo) {
                        if (processinfo.backend == null) continue;
                        try {
                            processinfo.backend.jobFinished(this);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (this.myJobScheduler == null) break;
                    try {
                        this.myJobScheduler.jobFinished(this);
                    }
                    catch (IOException iOException) {}
                    break;
                }
                case 1: {
                    for (ProcessInfo processinfo : this.myProcessInfo) {
                        if (processinfo.backend == null || processinfo.state == ProcessInfo.State.FAILED) continue;
                        try {
                            processinfo.backend.cancelJob(this, this.myCancelMessage);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (this.myJobScheduler == null) break;
                    try {
                        this.myJobScheduler.cancelJob(this, this.myCancelMessage);
                    }
                    catch (IOException iOException) {}
                    break;
                }
            }
            this.myState = State.TERMINATING;
        }
    }

    private static enum State {
        RUNNING,
        TERMINATE_CANCEL_JOB,
        TERMINATING;

    }
}

