/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import edu.rit.pj.cluster.JobBackendRef;
import edu.rit.pj.cluster.JobFrontendRef;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.concurrent.LinkedBlockingQueue;

public class BackendFileOutputStream
extends OutputStream {
    private JobFrontendRef myJobFrontend;
    private JobBackendRef myJobBackend;
    private LinkedBlockingQueue<Result> myResultQueue = new LinkedBlockingQueue();
    private int ffd;

    BackendFileOutputStream(JobFrontendRef theJobFrontend, JobBackendRef theJobBackend) {
        this.myJobFrontend = theJobFrontend;
        this.myJobBackend = theJobBackend;
    }

    BackendFileOutputStream(JobFrontendRef theJobFrontend, JobBackendRef theJobBackend, int ffd) {
        this.myJobFrontend = theJobFrontend;
        this.myJobBackend = theJobBackend;
        this.ffd = ffd;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > buf.length) {
            throw new IndexOutOfBoundsException();
        }
        this.verifyOpen();
        this.myJobFrontend.outputFileWrite(this.myJobBackend, this.ffd, buf, off, len);
        this.getResult();
    }

    @Override
    public void flush() throws IOException {
        this.verifyOpen();
        this.myJobFrontend.outputFileFlush(this.myJobBackend, this.ffd);
        this.getResult();
    }

    @Override
    public void close() throws IOException {
        this.verifyOpen();
        try {
            this.myJobFrontend.outputFileClose(this.myJobBackend, this.ffd);
            this.getResult();
        }
        finally {
            this.ffd = 0;
        }
    }

    int open(int bfd, File file, boolean append) throws IOException {
        this.myJobFrontend.outputFileOpen(this.myJobBackend, bfd, file, append);
        this.ffd = this.getResult().ffd;
        return this.ffd;
    }

    private Result getResult() throws IOException {
        try {
            Result result = this.myResultQueue.take();
            if (result.exc != null) {
                throw result.exc;
            }
            return result;
        }
        catch (InterruptedException exc) {
            InterruptedIOException exc2 = new InterruptedIOException("I/O interrupted");
            exc2.initCause(exc);
            throw exc2;
        }
    }

    void putResult(int ffd, IOException exc) {
        this.myResultQueue.offer(new Result(ffd, exc));
    }

    private void verifyOpen() throws IOException {
        if (this.ffd == 0) {
            throw new IOException("File closed");
        }
    }

    private static class Result {
        public int ffd;
        public IOException exc;

        public Result(int ffd, IOException exc) {
            this.ffd = ffd;
            this.exc = exc;
        }
    }
}

