/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

import edu.rit.mp.ObjectBuf;
import edu.rit.mp.buf.ObjectItemBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.CommStatus;
import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.WorkerForLoop;
import edu.rit.pj.WorkerTeam;
import edu.rit.util.Range;
import java.io.IOException;

public abstract class WorkerIntegerForLoop
extends WorkerForLoop {
    public IntegerSchedule schedule() {
        return IntegerSchedule.runtime();
    }

    public void start() throws Exception {
    }

    public void sendTaskInput(Range range, Comm comm, int wRank, int tag) throws IOException {
    }

    public void receiveTaskInput(Range range, Comm comm, int mRank, int tag) throws IOException {
    }

    public abstract void run(int var1, int var2) throws Exception;

    public void sendTaskOutput(Range range, Comm comm, int mRank, int tag) throws IOException {
    }

    public void receiveTaskOutput(Range range, Comm comm, int wRank, int tag) throws IOException {
    }

    public void finish() throws Exception {
    }

    public int tagOffset() {
        return Integer.MIN_VALUE;
    }

    void masterExecute(Range range) throws IOException {
        IntegerSchedule sch = this.schedule();
        if (sch.isFixedSchedule()) {
            this.masterExecuteFixed(range, sch);
        } else {
            this.masterExecuteNonFixed(range, sch);
        }
    }

    void masterExecuteFixed(Range range, IntegerSchedule sch) throws IOException {
        Range chunk;
        int w;
        int count = this.myTeam.count;
        Comm comm = this.myTeam.comm;
        sch.start(count, range);
        for (w = 0; w < count; ++w) {
            chunk = sch.next(w);
            if (chunk == null) continue;
            this.sendTaskInput(chunk, comm, this.myTeam.workerRank(w), this.tagFor(w));
        }
        sch.start(count, range);
        for (w = 0; w < count; ++w) {
            chunk = sch.next(w);
            if (chunk == null) continue;
            this.receiveTaskOutput(chunk, comm, this.myTeam.workerRank(w), this.tagFor(w));
        }
    }

    void masterExecuteNonFixed(Range range, IntegerSchedule sch) throws IOException {
        int tag;
        int r;
        Range chunk;
        int count = this.myTeam.count;
        sch.start(count, range);
        int remaining = count;
        ObjectItemBuf buf = ObjectBuf.buffer();
        Range tagRange = new Range(this.tagFor(0), this.tagFor(count - 1));
        Comm comm = this.myTeam.comm;
        for (int w = 0; w < count; ++w) {
            chunk = sch.next(w);
            buf.item = chunk;
            buf.reset();
            r = this.myTeam.workerRank(w);
            tag = this.tagFor(w);
            comm.send(r, tag, buf);
            if (chunk == null) {
                --remaining;
                continue;
            }
            this.sendTaskInput(chunk, comm, r, tag);
        }
        while (remaining > 0) {
            CommStatus status = comm.receive(null, tagRange, buf);
            chunk = (Range)buf.item;
            r = status.fromRank;
            tag = status.tag;
            int w = this.workerFor(tag);
            this.receiveTaskOutput(chunk, comm, r, tag);
            chunk = sch.next(w);
            buf.item = chunk;
            buf.reset();
            comm.send(r, tag, buf);
            if (chunk == null) {
                --remaining;
                continue;
            }
            this.sendTaskInput(chunk, comm, r, tag);
        }
    }

    void workerExecute(int w, Range range) throws Exception {
        IntegerSchedule sch = this.schedule();
        if (sch.isFixedSchedule()) {
            sch.start(this.myTeam.count, range);
            this.workerExecuteFixed(sch.next(w), w);
        } else {
            this.workerExecuteNonFixed(w);
        }
    }

    void workerExecuteFixed(Range range, int w) throws Exception {
        this.start();
        if (range != null) {
            Comm comm = this.myTeam.comm;
            int r = this.myTeam.masterRank();
            int tag = this.tagFor(w);
            this.receiveTaskInput(range, comm, r, tag);
            this.run(range.lb(), range.ub());
            this.sendTaskOutput(range, comm, r, tag);
        }
        this.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void workerExecuteNonFixed(int w) throws Exception {
        Comm comm = this.myTeam.comm;
        int r = this.myTeam.masterRank();
        int tag = this.tagFor(w);
        this.start();
        ObjectItemBuf buf = ObjectBuf.buffer();
        while (true) {
            comm.receive((Integer)r, tag, buf);
            Range range = (Range)buf.item;
            if (range == null) break;
            this.receiveTaskInput(range, comm, r, tag);
            this.run(range.lb(), range.ub());
            WorkerTeam workerTeam = this.myTeam;
            synchronized (workerTeam) {
                comm.send(r, tag, buf);
                this.sendTaskOutput(range, comm, r, tag);
            }
        }
        this.finish();
    }

    private int tagFor(int w) {
        return w + this.tagOffset();
    }

    private int workerFor(int tag) {
        return tag - this.tagOffset();
    }
}

