/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.Unsigned8BitIntegerBuf;
import edu.rit.mp.buf.Unsigned8BitIntegerItemBuf;
import edu.rit.pj.reduction.IntegerOp;
import edu.rit.pj.reduction.Op;
import java.nio.ByteBuffer;

class Unsigned8BitIntegerItemReductionBuf
extends Unsigned8BitIntegerBuf {
    Unsigned8BitIntegerItemBuf myBuf;
    IntegerOp myOp;

    public Unsigned8BitIntegerItemReductionBuf(Unsigned8BitIntegerItemBuf buf, IntegerOp op) {
        super(1);
        if (op == null) {
            throw new NullPointerException("Unsigned8BitIntegerItemReductionBuf(): op is null");
        }
        this.myBuf = buf;
        this.myOp = op;
    }

    @Override
    public int get(int i) {
        return this.myBuf.item;
    }

    @Override
    public void put(int i, int item) {
        this.myBuf.item = this.myOp.op(this.myBuf.item, item);
    }

    @Override
    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int sendItems(int i, ByteBuffer buffer) {
        if (buffer.remaining() >= 1) {
            buffer.put((byte)this.myBuf.item);
            return 1;
        }
        return 0;
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        if (num >= 1 && buffer.remaining() >= 1) {
            this.myBuf.item = this.myOp.op(this.myBuf.item, buffer.get() & 0xFF);
            return 1;
        }
        return 0;
    }
}

