/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.Unsigned8BitIntegerBuf;
import edu.rit.mp.buf.Unsigned8BitIntegerArrayBuf;
import edu.rit.pj.reduction.IntegerOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.ReduceArrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

class Unsigned8BitIntegerArrayReductionBuf
extends Unsigned8BitIntegerArrayBuf {
    IntegerOp myOp;

    public Unsigned8BitIntegerArrayReductionBuf(int[] theArray, Range theRange, IntegerOp op) {
        super(theArray, theRange);
        if (op == null) {
            throw new NullPointerException("Unsigned8BitIntegerArrayReductionBuf(): op is null");
        }
        this.myOp = op;
    }

    @Override
    public void put(int i, int item) {
        int off = this.myArrayOffset + i * this.myStride;
        this.myArray[off] = this.myOp.op(this.myArray[off], item);
    }

    @Override
    public void copy(Buf theSrc) {
        if (theSrc != this) {
            if (theSrc instanceof Unsigned8BitIntegerArrayBuf) {
                Unsigned8BitIntegerArrayBuf src = (Unsigned8BitIntegerArrayBuf)theSrc;
                ReduceArrays.reduce(src.myArray, src.myRange, this.myArray, this.myRange, this.myOp);
            } else {
                Unsigned8BitIntegerBuf.defaultCopy((Unsigned8BitIntegerBuf)theSrc, this);
            }
        }
    }

    @Override
    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        int index = i;
        int off = this.myArrayOffset + i * this.myStride;
        int max = Math.min(i + num, this.myLength);
        while (index < max && buffer.remaining() >= 1) {
            this.myArray[off] = this.myOp.op(this.myArray[off], buffer.get() & 0xFF);
            ++index;
            off += this.myStride;
        }
        return index - i;
    }
}

