/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.ShortBuf;
import edu.rit.mp.buf.ShortMatrixBuf;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.ReduceArrays;
import edu.rit.pj.reduction.ShortOp;
import edu.rit.util.Range;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;

class ShortMatrixReductionBuf
extends ShortMatrixBuf {
    ShortOp myOp;

    public ShortMatrixReductionBuf(short[][] theMatrix, Range theRowRange, Range theColRange, ShortOp op) {
        super(theMatrix, theRowRange, theColRange);
        if (op == null) {
            throw new NullPointerException("ShortMatrixReductionBuf(): op is null");
        }
        this.myOp = op;
    }

    @Override
    public void put(int i, short item) {
        int row = i / this.myColCount * this.myRowStride + this.myLowerRow;
        int col = i % this.myColCount * this.myColStride + this.myLowerCol;
        this.myMatrix[row][col] = this.myOp.op(this.myMatrix[row][col], item);
    }

    @Override
    public void copy(Buf theSrc) {
        if (theSrc != this) {
            if (theSrc instanceof ShortMatrixBuf) {
                ShortMatrixBuf src = (ShortMatrixBuf)theSrc;
                ReduceArrays.reduce(src.myMatrix, src.myRowRange, src.myColRange, this.myMatrix, this.myRowRange, this.myColRange, this.myOp);
            } else {
                ShortBuf.defaultCopy((ShortBuf)theSrc, this);
            }
        }
    }

    @Override
    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        ShortBuffer shortbuffer = buffer.asShortBuffer();
        num = Math.min(num, shortbuffer.remaining());
        int n = 0;
        int r = this.i2r(i);
        int row = r * this.myRowStride + this.myLowerRow;
        int c = this.i2c(i);
        int col = c * this.myColStride + this.myLowerCol;
        int ncols = Math.min(this.myColCount - c, num);
        while (r < this.myRowCount && ncols > 0) {
            short[] myMatrix_row = this.myMatrix[row];
            for (c = 0; c < ncols; ++c) {
                myMatrix_row[col] = this.myOp.op(myMatrix_row[col], shortbuffer.get());
                col += this.myColStride;
            }
            n += ncols;
            ++r;
            row += this.myRowStride;
            col = this.myLowerCol;
            ncols = Math.min(this.myColCount, num -= ncols);
        }
        buffer.position(buffer.position() + 2 * n);
        return n;
    }
}

