/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.ShortBuf;
import edu.rit.mp.buf.ShortItemBuf;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.ShortOp;
import java.nio.ByteBuffer;

class ShortItemReductionBuf
extends ShortBuf {
    ShortItemBuf myBuf;
    ShortOp myOp;

    public ShortItemReductionBuf(ShortItemBuf buf, ShortOp op) {
        super(1);
        if (op == null) {
            throw new NullPointerException("ShortItemReductionBuf(): op is null");
        }
        this.myBuf = buf;
        this.myOp = op;
    }

    @Override
    public short get(int i) {
        return this.myBuf.item;
    }

    @Override
    public void put(int i, short item) {
        this.myBuf.item = this.myOp.op(this.myBuf.item, item);
    }

    @Override
    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int sendItems(int i, ByteBuffer buffer) {
        if (buffer.remaining() >= 2) {
            buffer.putShort(this.myBuf.item);
            return 1;
        }
        return 0;
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        if (num >= 1 && buffer.remaining() >= 2) {
            this.myBuf.item = this.myOp.op(this.myBuf.item, buffer.getShort());
            return 1;
        }
        return 0;
    }
}

