/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.ShortBuf;
import edu.rit.mp.buf.ShortArrayBuf;
import edu.rit.mp.buf.ShortArrayBuf_1;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.ReduceArrays;
import edu.rit.pj.reduction.ShortOp;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

class ShortArrayReductionBuf_1
extends ShortArrayBuf_1 {
    ShortOp myOp;

    public ShortArrayReductionBuf_1(short[] theArray, Range theRange, ShortOp op) {
        super(theArray, theRange);
        if (op == null) {
            throw new NullPointerException("ShortArrayReductionBuf_1(): op is null");
        }
        this.myOp = op;
    }

    @Override
    public void put(int i, short item) {
        int off = this.myArrayOffset + i;
        this.myArray[off] = this.myOp.op(this.myArray[off], item);
    }

    @Override
    public void copy(Buf theSrc) {
        if (theSrc != this) {
            if (theSrc instanceof ShortArrayBuf) {
                ShortArrayBuf src = (ShortArrayBuf)theSrc;
                ReduceArrays.reduce(src.myArray, src.myRange, this.myArray, this.myRange, this.myOp);
            } else {
                ShortBuf.defaultCopy((ShortBuf)theSrc, this);
            }
        }
    }

    @Override
    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        int index = i;
        int off = this.myArrayOffset + i;
        int max = Math.min(i + num, this.myLength);
        while (index < max && buffer.remaining() >= 2) {
            this.myArray[off] = this.myOp.op(this.myArray[off], buffer.getShort());
            ++index;
            ++off;
        }
        return index - i;
    }
}

