/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.ObjectBuf;
import edu.rit.mp.buf.SharedObjectArrayReductionBuf;
import edu.rit.pj.reduction.ObjectOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.SharedObjectArray;
import edu.rit.util.Range;

public class SharedObjectArrayBuf<T>
extends ObjectBuf<T> {
    SharedObjectArray<T> myArray;
    Range myRange;
    int myArrayOffset;
    int myStride;

    public SharedObjectArrayBuf(SharedObjectArray<T> theArray, Range theRange) {
        super(theRange.length());
        this.myArray = theArray;
        this.myRange = theRange;
        this.myArrayOffset = theRange.lb();
        this.myStride = theRange.stride();
    }

    @Override
    public T get(int i) {
        return this.myArray.get(this.myArrayOffset + i * this.myStride);
    }

    @Override
    public void put(int i, T item) {
        this.myArray.set(this.myArrayOffset + i * this.myStride, item);
        this.mySerializedItems = null;
    }

    @Override
    public Buf getReductionBuf(Op op) {
        return new SharedObjectArrayReductionBuf<T>(this.myArray, this.myRange, (ObjectOp)op, this);
    }
}

