/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.LongBuf;
import edu.rit.mp.buf.SharedLongArrayReductionBuf;
import edu.rit.pj.reduction.LongOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.SharedLongArray;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public class SharedLongArrayBuf
extends LongBuf {
    SharedLongArray myArray;
    Range myRange;
    int myArrayOffset;
    int myStride;

    public SharedLongArrayBuf(SharedLongArray theArray, Range theRange) {
        super(theRange.length());
        this.myArray = theArray;
        this.myRange = theRange;
        this.myArrayOffset = theRange.lb();
        this.myStride = theRange.stride();
    }

    @Override
    public long get(int i) {
        return this.myArray.get(this.myArrayOffset + i * this.myStride);
    }

    @Override
    public void put(int i, long item) {
        this.myArray.set(this.myArrayOffset + i * this.myStride, item);
    }

    @Override
    public Buf getReductionBuf(Op op) {
        return new SharedLongArrayReductionBuf(this.myArray, this.myRange, (LongOp)op);
    }

    @Override
    protected int sendItems(int i, ByteBuffer buffer) {
        int index = i;
        int off = this.myArrayOffset + i * this.myStride;
        while (index < this.myLength && buffer.remaining() >= 8) {
            buffer.putLong(this.myArray.get(off));
            ++index;
            off += this.myStride;
        }
        return index - i;
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        int index = i;
        int off = this.myArrayOffset + i * this.myStride;
        int max = Math.min(i + num, this.myLength);
        while (index < max && buffer.remaining() >= 8) {
            this.myArray.set(off, buffer.getLong());
            ++index;
            off += this.myStride;
        }
        return index - i;
    }
}

