/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.buf.SharedFloatArrayBuf;
import edu.rit.mp.buf.SharedFloatArrayReductionBuf_1;
import edu.rit.pj.reduction.FloatOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.SharedFloatArray;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public class SharedFloatArrayBuf_1
extends SharedFloatArrayBuf {
    public SharedFloatArrayBuf_1(SharedFloatArray theArray, Range theRange) {
        super(theArray, theRange);
    }

    @Override
    public float get(int i) {
        return this.myArray.get(this.myArrayOffset + i);
    }

    @Override
    public void put(int i, float item) {
        this.myArray.set(this.myArrayOffset + i, item);
    }

    @Override
    public Buf getReductionBuf(Op op) {
        return new SharedFloatArrayReductionBuf_1(this.myArray, this.myRange, (FloatOp)op);
    }

    @Override
    protected int sendItems(int i, ByteBuffer buffer) {
        int index = i;
        int off = this.myArrayOffset + i;
        while (index < this.myLength && buffer.remaining() >= 4) {
            buffer.putFloat(this.myArray.get(off));
            ++index;
            ++off;
        }
        return index - i;
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        int index = i;
        int off = this.myArrayOffset + i;
        int max = Math.min(i + num, this.myLength);
        while (index < max && buffer.remaining() >= 4) {
            this.myArray.set(off, buffer.getFloat());
            ++index;
            ++off;
        }
        return index - i;
    }
}

