/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.buf.SharedDoubleArrayBuf;
import edu.rit.mp.buf.SharedDoubleArrayReductionBuf_1;
import edu.rit.pj.reduction.DoubleOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.SharedDoubleArray;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public class SharedDoubleArrayBuf_1
extends SharedDoubleArrayBuf {
    public SharedDoubleArrayBuf_1(SharedDoubleArray theArray, Range theRange) {
        super(theArray, theRange);
    }

    @Override
    public double get(int i) {
        return this.myArray.get(this.myArrayOffset + i);
    }

    @Override
    public void put(int i, double item) {
        this.myArray.set(this.myArrayOffset + i, item);
    }

    @Override
    public Buf getReductionBuf(Op op) {
        return new SharedDoubleArrayReductionBuf_1(this.myArray, this.myRange, (DoubleOp)op);
    }

    @Override
    protected int sendItems(int i, ByteBuffer buffer) {
        int index = i;
        int off = this.myArrayOffset + i;
        while (index < this.myLength && buffer.remaining() >= 8) {
            buffer.putDouble(this.myArray.get(off));
            ++index;
            ++off;
        }
        return index - i;
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        int index = i;
        int off = this.myArrayOffset + i;
        int max = Math.min(i + num, this.myLength);
        while (index < max && buffer.remaining() >= 8) {
            this.myArray.set(off, buffer.getDouble());
            ++index;
            ++off;
        }
        return index - i;
    }
}

