/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.ByteBuf;
import edu.rit.mp.buf.SharedByteArrayReductionBuf;
import edu.rit.pj.reduction.ByteOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.SharedByteArray;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public class SharedByteArrayBuf
extends ByteBuf {
    SharedByteArray myArray;
    Range myRange;
    int myArrayOffset;
    int myStride;

    public SharedByteArrayBuf(SharedByteArray theArray, Range theRange) {
        super(theRange.length());
        this.myArray = theArray;
        this.myRange = theRange;
        this.myArrayOffset = theRange.lb();
        this.myStride = theRange.stride();
    }

    @Override
    public byte get(int i) {
        return this.myArray.get(this.myArrayOffset + i * this.myStride);
    }

    @Override
    public void put(int i, byte item) {
        this.myArray.set(this.myArrayOffset + i * this.myStride, item);
    }

    @Override
    public Buf getReductionBuf(Op op) {
        return new SharedByteArrayReductionBuf(this.myArray, this.myRange, (ByteOp)op);
    }

    @Override
    protected int sendItems(int i, ByteBuffer buffer) {
        int index = i;
        int off = this.myArrayOffset + i * this.myStride;
        while (index < this.myLength && buffer.remaining() >= 1) {
            buffer.put(this.myArray.get(off));
            ++index;
            off += this.myStride;
        }
        return index - i;
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        int index = i;
        int off = this.myArrayOffset + i * this.myStride;
        int max = Math.min(i + num, this.myLength);
        while (index < max && buffer.remaining() >= 1) {
            this.myArray.set(off, buffer.get());
            ++index;
            off += this.myStride;
        }
        return index - i;
    }
}

