/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.buf.SharedBooleanArrayBuf;
import edu.rit.pj.reduction.BooleanOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.SharedBooleanArray;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

class SharedBooleanArrayReductionBuf
extends SharedBooleanArrayBuf {
    BooleanOp myOp;

    public SharedBooleanArrayReductionBuf(SharedBooleanArray theArray, Range theRange, BooleanOp op) {
        super(theArray, theRange);
        if (op == null) {
            throw new NullPointerException("SharedBooleanArrayReductionBuf(): op is null");
        }
        this.myOp = op;
    }

    @Override
    public void put(int i, boolean item) {
        this.myArray.reduce(this.myArrayOffset + i * this.myStride, item, this.myOp);
    }

    @Override
    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        int index = i;
        int off = this.myArrayOffset + i * this.myStride;
        int max = Math.min(i + num, this.myLength);
        while (index < max && buffer.remaining() >= 1) {
            this.myArray.reduce(off, buffer.get() != 0, this.myOp);
            ++index;
            off += this.myStride;
        }
        return index - i;
    }
}

