/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.LongBuf;
import edu.rit.mp.buf.LongArrayBuf;
import edu.rit.mp.buf.LongArrayBuf_1;
import edu.rit.pj.reduction.LongOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.ReduceArrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

class LongArrayReductionBuf_1
extends LongArrayBuf_1 {
    LongOp myOp;

    public LongArrayReductionBuf_1(long[] theArray, Range theRange, LongOp op) {
        super(theArray, theRange);
        if (op == null) {
            throw new NullPointerException("LongArrayReductionBuf_1(): op is null");
        }
        this.myOp = op;
    }

    @Override
    public void put(int i, long item) {
        int off = this.myArrayOffset + i;
        this.myArray[off] = this.myOp.op(this.myArray[off], item);
    }

    @Override
    public void copy(Buf theSrc) {
        if (theSrc != this) {
            if (theSrc instanceof LongArrayBuf) {
                LongArrayBuf src = (LongArrayBuf)theSrc;
                ReduceArrays.reduce(src.myArray, src.myRange, this.myArray, this.myRange, this.myOp);
            } else {
                LongBuf.defaultCopy((LongBuf)theSrc, this);
            }
        }
    }

    @Override
    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        int index = i;
        int off = this.myArrayOffset + i;
        int max = Math.min(i + num, this.myLength);
        while (index < max && buffer.remaining() >= 8) {
            this.myArray[off] = this.myOp.op(this.myArray[off], buffer.getLong());
            ++index;
            ++off;
        }
        return index - i;
    }
}

