/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.IntegerBuf;
import edu.rit.mp.buf.IntegerArrayBuf;
import edu.rit.pj.reduction.IntegerOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.ReduceArrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

class IntegerArrayReductionBuf
extends IntegerArrayBuf {
    IntegerOp myOp;

    public IntegerArrayReductionBuf(int[] theArray, Range theRange, IntegerOp op) {
        super(theArray, theRange);
        if (op == null) {
            throw new NullPointerException("IntegerArrayReductionBuf(): op is null");
        }
        this.myOp = op;
    }

    @Override
    public void put(int i, int item) {
        int off = this.myArrayOffset + i * this.myStride;
        this.myArray[off] = this.myOp.op(this.myArray[off], item);
    }

    @Override
    public void copy(Buf theSrc) {
        if (theSrc != this) {
            if (theSrc instanceof IntegerArrayBuf) {
                IntegerArrayBuf src = (IntegerArrayBuf)theSrc;
                ReduceArrays.reduce(src.myArray, src.myRange, this.myArray, this.myRange, this.myOp);
            } else {
                IntegerBuf.defaultCopy((IntegerBuf)theSrc, this);
            }
        }
    }

    @Override
    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        int index = i;
        int off = this.myArrayOffset + i * this.myStride;
        int max = Math.min(i + num, this.myLength);
        while (index < max && buffer.remaining() >= 4) {
            this.myArray[off] = this.myOp.op(this.myArray[off], buffer.getInt());
            ++index;
            off += this.myStride;
        }
        return index - i;
    }
}

