/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.buf.DoubleMatrixBuf;
import edu.rit.mp.buf.DoubleMatrixReductionBuf_1;
import edu.rit.pj.reduction.DoubleOp;
import edu.rit.pj.reduction.Op;
import edu.rit.util.Range;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;

public class DoubleMatrixBuf_1
extends DoubleMatrixBuf {
    public DoubleMatrixBuf_1(double[][] theMatrix, Range theRowRange, Range theColRange) {
        super(theMatrix, theRowRange, theColRange);
    }

    @Override
    public double get(int i) {
        return this.myMatrix[this.i2r(i) + this.myLowerRow][this.i2c(i) + this.myLowerCol];
    }

    @Override
    public void put(int i, double item) {
        this.myMatrix[this.i2r((int)i) + this.myLowerRow][this.i2c((int)i) + this.myLowerCol] = item;
    }

    @Override
    public Buf getReductionBuf(Op op) {
        return new DoubleMatrixReductionBuf_1(this.myMatrix, this.myRowRange, this.myColRange, (DoubleOp)op);
    }

    @Override
    protected int sendItems(int i, ByteBuffer buffer) {
        DoubleBuffer doublebuffer = buffer.asDoubleBuffer();
        int n = 0;
        int r = this.i2r(i);
        int row = r + this.myLowerRow;
        int c = this.i2c(i);
        int col = c + this.myLowerCol;
        int ncols = Math.min(this.myColCount - c, doublebuffer.remaining());
        while (r < this.myRowCount && ncols > 0) {
            doublebuffer.put(this.myMatrix[row], col, ncols);
            n += ncols;
            ++r;
            ++row;
            c = 0;
            col = this.myLowerCol;
            ncols = Math.min(this.myColCount, doublebuffer.remaining());
        }
        buffer.position(buffer.position() + 8 * n);
        return n;
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        DoubleBuffer doublebuffer = buffer.asDoubleBuffer();
        num = Math.min(num, doublebuffer.remaining());
        int n = 0;
        int r = this.i2r(i);
        int row = r + this.myLowerRow;
        int c = this.i2c(i);
        int col = c + this.myLowerCol;
        int ncols = Math.min(this.myColCount - c, num);
        while (r < this.myRowCount && ncols > 0) {
            doublebuffer.get(this.myMatrix[row], col, ncols);
            num -= ncols;
            n += ncols;
            ++r;
            ++row;
            c = 0;
            col = this.myLowerCol;
            ncols = Math.min(this.myColCount, num);
        }
        buffer.position(buffer.position() + 8 * n);
        return n;
    }
}

