/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.DoubleBuf;
import edu.rit.mp.buf.DoubleItemBuf;
import edu.rit.pj.reduction.DoubleOp;
import edu.rit.pj.reduction.Op;
import java.nio.ByteBuffer;

class DoubleItemReductionBuf
extends DoubleBuf {
    DoubleItemBuf myBuf;
    DoubleOp myOp;

    public DoubleItemReductionBuf(DoubleItemBuf buf, DoubleOp op) {
        super(1);
        if (op == null) {
            throw new NullPointerException("DoubleItemReductionBuf(): op is null");
        }
        this.myBuf = buf;
        this.myOp = op;
    }

    @Override
    public double get(int i) {
        return this.myBuf.item;
    }

    @Override
    public void put(int i, double item) {
        this.myBuf.item = this.myOp.op(this.myBuf.item, item);
    }

    @Override
    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int sendItems(int i, ByteBuffer buffer) {
        if (buffer.remaining() >= 8) {
            buffer.putDouble(this.myBuf.item);
            return 1;
        }
        return 0;
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        if (num >= 1 && buffer.remaining() >= 8) {
            this.myBuf.item = this.myOp.op(this.myBuf.item, buffer.getDouble());
            return 1;
        }
        return 0;
    }
}

