/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.buf.ByteMatrixBuf;
import edu.rit.mp.buf.ByteMatrixReductionBuf_1;
import edu.rit.pj.reduction.ByteOp;
import edu.rit.pj.reduction.Op;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public class ByteMatrixBuf_1
extends ByteMatrixBuf {
    public ByteMatrixBuf_1(byte[][] theMatrix, Range theRowRange, Range theColRange) {
        super(theMatrix, theRowRange, theColRange);
    }

    @Override
    public byte get(int i) {
        return this.myMatrix[this.i2r(i) + this.myLowerRow][this.i2c(i) + this.myLowerCol];
    }

    @Override
    public void put(int i, byte item) {
        this.myMatrix[this.i2r((int)i) + this.myLowerRow][this.i2c((int)i) + this.myLowerCol] = item;
    }

    @Override
    public Buf getReductionBuf(Op op) {
        return new ByteMatrixReductionBuf_1(this.myMatrix, this.myRowRange, this.myColRange, (ByteOp)op);
    }

    @Override
    protected int sendItems(int i, ByteBuffer buffer) {
        int n = 0;
        int r = this.i2r(i);
        int row = r + this.myLowerRow;
        int c = this.i2c(i);
        int col = c + this.myLowerCol;
        int ncols = Math.min(this.myColCount - c, buffer.remaining());
        while (r < this.myRowCount && ncols > 0) {
            buffer.put(this.myMatrix[row], col, ncols);
            n += ncols;
            ++r;
            ++row;
            c = 0;
            col = this.myLowerCol;
            ncols = Math.min(this.myColCount, buffer.remaining());
        }
        return n;
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        num = Math.min(num, buffer.remaining());
        int n = 0;
        int r = this.i2r(i);
        int row = r + this.myLowerRow;
        int c = this.i2c(i);
        int col = c + this.myLowerCol;
        int ncols = Math.min(this.myColCount - c, num);
        while (r < this.myRowCount && ncols > 0) {
            buffer.get(this.myMatrix[row], col, ncols);
            n += ncols;
            ++r;
            ++row;
            col = this.myLowerCol;
            ncols = Math.min(this.myColCount, num -= ncols);
        }
        return n;
    }
}

