/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.ByteBuf;
import edu.rit.mp.buf.ByteArrayBuf;
import edu.rit.mp.buf.ByteArrayBuf_1;
import edu.rit.pj.reduction.ByteOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.ReduceArrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

class ByteArrayReductionBuf_1
extends ByteArrayBuf_1 {
    ByteOp myOp;

    public ByteArrayReductionBuf_1(byte[] theArray, Range theRange, ByteOp op) {
        super(theArray, theRange);
        if (op == null) {
            throw new NullPointerException("ByteArrayReductionBuf_1(): op is null");
        }
        this.myOp = op;
    }

    @Override
    public void put(int i, byte item) {
        int off = this.myArrayOffset + i;
        this.myArray[off] = this.myOp.op(this.myArray[off], item);
    }

    @Override
    public void copy(Buf theSrc) {
        if (theSrc != this) {
            if (theSrc instanceof ByteArrayBuf) {
                ByteArrayBuf src = (ByteArrayBuf)theSrc;
                ReduceArrays.reduce(src.myArray, src.myRange, this.myArray, this.myRange, this.myOp);
            } else {
                ByteBuf.defaultCopy((ByteBuf)theSrc, this);
            }
        }
    }

    @Override
    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        int index = i;
        int off = this.myArrayOffset + i;
        int max = Math.min(i + num, this.myLength);
        while (index < max && buffer.remaining() >= 1) {
            this.myArray[off] = this.myOp.op(this.myArray[off], buffer.get());
            ++index;
            ++off;
        }
        return index - i;
    }
}

