/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.buf.BooleanArrayBuf;
import edu.rit.mp.buf.BooleanArrayReductionBuf_1;
import edu.rit.pj.reduction.BooleanOp;
import edu.rit.pj.reduction.Op;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public class BooleanArrayBuf_1
extends BooleanArrayBuf {
    public BooleanArrayBuf_1(boolean[] theArray, Range theRange) {
        super(theArray, theRange);
    }

    @Override
    public boolean get(int i) {
        return this.myArray[this.myArrayOffset + i];
    }

    @Override
    public void put(int i, boolean item) {
        this.myArray[this.myArrayOffset + i] = item;
    }

    @Override
    public Buf getReductionBuf(Op op) {
        return new BooleanArrayReductionBuf_1(this.myArray, this.myRange, (BooleanOp)op);
    }

    @Override
    protected int sendItems(int i, ByteBuffer buffer) {
        int index = i;
        int off = this.myArrayOffset + i;
        while (index < this.myLength && buffer.remaining() >= 1) {
            buffer.put(this.myArray[off] ? (byte)1 : 0);
            ++index;
            ++off;
        }
        return index - i;
    }

    @Override
    protected int receiveItems(int i, int num, ByteBuffer buffer) {
        int index = i;
        int off = this.myArrayOffset + i;
        int max = Math.min(i + num, this.myLength);
        while (index < max && buffer.remaining() >= 1) {
            this.myArray[off] = buffer.get() != 0;
            ++index;
            ++off;
        }
        return index - i;
    }
}

