/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp;

import edu.rit.mp.Buf;
import edu.rit.mp.buf.EmptyShortBuf;
import edu.rit.mp.buf.SharedShortArrayBuf;
import edu.rit.mp.buf.SharedShortArrayBuf_1;
import edu.rit.mp.buf.SharedShortBuf;
import edu.rit.mp.buf.ShortArrayBuf;
import edu.rit.mp.buf.ShortArrayBuf_1;
import edu.rit.mp.buf.ShortItemBuf;
import edu.rit.mp.buf.ShortMatrixBuf;
import edu.rit.mp.buf.ShortMatrixBuf_1;
import edu.rit.pj.reduction.SharedShort;
import edu.rit.pj.reduction.SharedShortArray;
import edu.rit.util.Arrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public abstract class ShortBuf
extends Buf {
    protected ShortBuf(int theLength) {
        super((byte)3, theLength);
    }

    public static ShortBuf emptyBuffer() {
        return new EmptyShortBuf();
    }

    public static ShortItemBuf buffer() {
        return new ShortItemBuf();
    }

    public static ShortItemBuf buffer(short item) {
        return new ShortItemBuf(item);
    }

    public static ShortBuf buffer(short[] theArray) {
        if (theArray == null) {
            throw new NullPointerException("ShortBuf.buffer(): theArray is null");
        }
        int nr = Arrays.length(theArray);
        return new ShortArrayBuf_1(theArray, new Range(0, nr - 1));
    }

    public static ShortBuf sliceBuffer(short[] theArray, Range theRange) {
        if (theArray == null) {
            throw new NullPointerException("ShortBuf.sliceBuffer(): theArray is null");
        }
        int nr = Arrays.length(theArray);
        if (0 > theRange.lb() || theRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("ShortBuf.sliceBuffer(): theArray index range = 0.." + (nr - 1) + ", theRange = " + String.valueOf(theRange));
        }
        if (theRange.stride() == 1) {
            return new ShortArrayBuf_1(theArray, theRange);
        }
        return new ShortArrayBuf(theArray, theRange);
    }

    public static ShortBuf[] sliceBuffers(short[] theArray, Range[] theRanges) {
        int n = theRanges.length;
        ShortBuf[] result = new ShortBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = ShortBuf.sliceBuffer(theArray, theRanges[i]);
        }
        return result;
    }

    public static ShortBuf buffer(short[][] theMatrix) {
        if (theMatrix == null) {
            throw new NullPointerException("ShortBuf.buffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        int nc = Arrays.colLength(theMatrix, 0);
        return new ShortMatrixBuf_1(theMatrix, new Range(0, nr - 1), new Range(0, nc - 1));
    }

    public static ShortBuf rowSliceBuffer(short[][] theMatrix, Range theRowRange) {
        if (theMatrix == null) {
            throw new NullPointerException("ShortBuf.rowSliceBuffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        if (0 > theRowRange.lb() || theRowRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("ShortBuf.rowSliceBuffer(): theMatrix row index range = 0.." + (nr - 1) + ", theRowRange = " + String.valueOf(theRowRange));
        }
        int nc = Arrays.colLength(theMatrix, theRowRange.lb());
        if (theRowRange.stride() == 1) {
            return new ShortMatrixBuf_1(theMatrix, theRowRange, new Range(0, nc - 1));
        }
        return new ShortMatrixBuf(theMatrix, theRowRange, new Range(0, nc - 1));
    }

    public static ShortBuf[] rowSliceBuffers(short[][] theMatrix, Range[] theRowRanges) {
        int n = theRowRanges.length;
        ShortBuf[] result = new ShortBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = ShortBuf.rowSliceBuffer(theMatrix, theRowRanges[i]);
        }
        return result;
    }

    public static ShortBuf colSliceBuffer(short[][] theMatrix, Range theColRange) {
        if (theMatrix == null) {
            throw new NullPointerException("ShortBuf.colSliceBuffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        int nc = Arrays.colLength(theMatrix, 0);
        if (0 > theColRange.lb() || theColRange.ub() >= nc) {
            throw new IndexOutOfBoundsException("ShortBuf.colSliceBuffer(): theMatrix column index range = 0.." + (nc - 1) + ", theColRange = " + String.valueOf(theColRange));
        }
        if (theColRange.stride() == 1) {
            return new ShortMatrixBuf_1(theMatrix, new Range(0, nr - 1), theColRange);
        }
        return new ShortMatrixBuf(theMatrix, new Range(0, nr - 1), theColRange);
    }

    public static ShortBuf[] colSliceBuffers(short[][] theMatrix, Range[] theColRanges) {
        int n = theColRanges.length;
        ShortBuf[] result = new ShortBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = ShortBuf.colSliceBuffer(theMatrix, theColRanges[i]);
        }
        return result;
    }

    public static ShortBuf patchBuffer(short[][] theMatrix, Range theRowRange, Range theColRange) {
        if (theMatrix == null) {
            throw new NullPointerException("ShortBuf.patchBuffer(): theMatrix is null");
        }
        int nr = Arrays.rowLength(theMatrix);
        if (0 > theRowRange.lb() || theRowRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("ShortBuf.patchBuffer(): theMatrix row index range = 0.." + (nr - 1) + ", theRowRange = " + String.valueOf(theRowRange));
        }
        int nc = Arrays.colLength(theMatrix, theRowRange.lb());
        if (0 > theColRange.lb() || theColRange.ub() >= nc) {
            throw new IndexOutOfBoundsException("ShortBuf.patchBuffer(): theMatrix column index range = 0.." + (nc - 1) + ", theColRange = " + String.valueOf(theColRange));
        }
        if (theRowRange.stride() == 1 && theColRange.stride() == 1) {
            return new ShortMatrixBuf_1(theMatrix, theRowRange, theColRange);
        }
        return new ShortMatrixBuf(theMatrix, theRowRange, theColRange);
    }

    public static ShortBuf[] patchBuffers(short[][] theMatrix, Range[] theRowRanges, Range[] theColRanges) {
        int m = theRowRanges.length;
        int n = theColRanges.length;
        ShortBuf[] result = new ShortBuf[m * n];
        int k = 0;
        for (int i = 0; i < m; ++i) {
            Range rowrange = theRowRanges[i];
            for (int j = 0; j < n; ++j) {
                result[k++] = ShortBuf.patchBuffer(theMatrix, rowrange, theColRanges[j]);
            }
        }
        return result;
    }

    public static ShortBuf buffer(SharedShort item) {
        if (item == null) {
            throw new NullPointerException("ShortBuf.buffer(): item is null");
        }
        return new SharedShortBuf(item);
    }

    public static ShortBuf buffer(SharedShortArray theArray) {
        if (theArray == null) {
            throw new NullPointerException("ShortBuf.buffer(): theArray is null");
        }
        int nr = theArray.length();
        return new SharedShortArrayBuf_1(theArray, new Range(0, nr - 1));
    }

    public static ShortBuf sliceBuffer(SharedShortArray theArray, Range theRange) {
        if (theArray == null) {
            throw new NullPointerException("ShortBuf.sliceBuffer(): theArray is null");
        }
        int nr = theArray.length();
        if (0 > theRange.lb() || theRange.ub() >= nr) {
            throw new IndexOutOfBoundsException("ShortBuf.sliceBuffer(): theArray index range = 0.." + (nr - 1) + ", theRange = " + String.valueOf(theRange));
        }
        if (theRange.stride() == 1) {
            return new SharedShortArrayBuf_1(theArray, theRange);
        }
        return new SharedShortArrayBuf(theArray, theRange);
    }

    public static ShortBuf[] sliceBuffers(SharedShortArray theArray, Range[] theRanges) {
        int n = theRanges.length;
        ShortBuf[] result = new ShortBuf[n];
        for (int i = 0; i < n; ++i) {
            result[i] = ShortBuf.sliceBuffer(theArray, theRanges[i]);
        }
        return result;
    }

    public abstract short get(int var1);

    public abstract void put(int var1, short var2);

    @Override
    public void copy(Buf theSrc) {
        if (theSrc != this) {
            ShortBuf.defaultCopy((ShortBuf)theSrc, this);
        }
    }

    @Override
    public void fill(Object item) {
        short value = item == null ? (short)0 : (Short)item;
        for (int i = 0; i < this.myLength; ++i) {
            this.put(i, value);
        }
    }

    @Override
    public Buf getTemporaryBuf() {
        return ShortBuf.buffer(new short[this.myLength]);
    }

    @Override
    int skipItems(int num, ByteBuffer buffer) {
        int n = Math.min(num, buffer.remaining() / 2);
        buffer.position(buffer.position() + 2 * n);
        return n;
    }

    protected static void defaultCopy(ShortBuf theSrc, ShortBuf theDst) {
        int n = Math.min(theSrc.myLength, theDst.myLength);
        for (int i = 0; i < n; ++i) {
            theDst.put(i, theSrc.get(i));
        }
    }
}

