/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp;

import edu.rit.mp.Channel;
import edu.rit.mp.ChannelGroup;
import edu.rit.mp.IORequest;
import edu.rit.mp.NetworkChannelReceiveThread;
import edu.rit.mp.NetworkChannelSendThread;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.concurrent.LinkedBlockingQueue;

class NetworkChannel
extends Channel {
    private SocketChannel mySocketChannel;
    private int myFarChannelGroupId;
    private LinkedBlockingQueue<IORequest> myOutgoingQueue;
    private NetworkChannelSendThread myNetworkChannelSendThread;
    private NetworkChannelReceiveThread myNetworkChannelReceiveThread;

    NetworkChannel(ChannelGroup theChannelGroup, SocketChannel theSocketChannel, int theFarChannelGroupId) {
        super(theChannelGroup);
        this.mySocketChannel = theSocketChannel;
        this.myFarChannelGroupId = theFarChannelGroupId;
        this.myOutgoingQueue = new LinkedBlockingQueue();
    }

    @Override
    public int nearEndChannelGroupId() {
        return this.myChannelGroup.myChannelGroupId;
    }

    @Override
    public int farEndChannelGroupId() {
        return this.myFarChannelGroupId;
    }

    @Override
    public InetSocketAddress nearEndAddress() {
        return (InetSocketAddress)this.mySocketChannel.socket().getLocalSocketAddress();
    }

    @Override
    public InetSocketAddress farEndAddress() {
        return (InetSocketAddress)this.mySocketChannel.socket().getRemoteSocketAddress();
    }

    @Override
    void start() {
        this.myNetworkChannelSendThread = new NetworkChannelSendThread(this, this.mySocketChannel, this.myOutgoingQueue);
        this.myNetworkChannelReceiveThread = new NetworkChannelReceiveThread(this, this.mySocketChannel);
    }

    @Override
    synchronized void send(IORequest theIORequest) throws IOException {
        if (this.myWriteState == 1) {
            throw new IOException("NetworkChannel.send(): Channel closed");
        }
        this.myOutgoingQueue.add(theIORequest);
    }

    @Override
    void subclassClose() {
        if (this.mySocketChannel != null) {
            try {
                this.mySocketChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.myNetworkChannelSendThread != null) {
            this.myNetworkChannelSendThread.interrupt();
        }
        if (this.myNetworkChannelReceiveThread != null) {
            this.myNetworkChannelReceiveThread.interrupt();
        }
        this.mySocketChannel = null;
        this.myOutgoingQueue = null;
        this.myNetworkChannelSendThread = null;
        this.myNetworkChannelReceiveThread = null;
    }

    synchronized void shutdownInput() {
        this.myReadState = 1;
        this.myNetworkChannelReceiveThread = null;
    }
}

