/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp;

import edu.rit.mp.Channel;
import edu.rit.mp.IORequest;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;

class IORequestList {
    LinkedList<IORequest> myList = new LinkedList();

    public synchronized void add(IORequest theIORequest) {
        this.myList.add(theIORequest);
        this.notifyAll();
    }

    public synchronized IORequest removeMatch(IORequest theIORequest) {
        Iterator iter = this.myList.iterator();
        while (iter.hasNext()) {
            IORequest iorequest = (IORequest)iter.next();
            if (!iorequest.match(theIORequest)) continue;
            iter.remove();
            return iorequest;
        }
        return null;
    }

    public synchronized IORequest removeMatch(Channel channel, Integer tag, byte type) {
        Iterator iter = this.myList.iterator();
        while (iter.hasNext()) {
            IORequest iorequest = (IORequest)iter.next();
            if (!iorequest.match(channel, tag, type)) continue;
            iter.remove();
            return iorequest;
        }
        return null;
    }

    public synchronized IORequest waitForMatch(IORequest theIORequest) throws InterruptedException {
        IORequest iorequest;
        while ((iorequest = this.removeMatch(theIORequest)) == null) {
            this.wait();
        }
        return iorequest;
    }

    public synchronized IORequest waitForMatch(Channel channel, Integer tag, byte type) throws InterruptedException {
        IORequest iorequest;
        while ((iorequest = this.removeMatch(channel, tag, type)) == null) {
            this.wait();
        }
        return iorequest;
    }

    public synchronized void reportFailure(IOException theIOException) {
        IORequest iorequest = null;
        while (!this.myList.isEmpty()) {
            iorequest = this.myList.remove(0);
            iorequest.reportFailure(theIOException);
        }
    }

    public synchronized void dump(PrintStream out, String prefix) {
        out.println(prefix + this.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this)));
        out.println(prefix + "\t" + this.myList.size() + " entries");
        for (IORequest r : this.myList) {
            out.println(prefix + "\t" + String.valueOf(r));
        }
    }
}

