/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.io;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LineBufferedOutputStream
extends FilterOutputStream {
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();

    public LineBufferedOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer.write(b);
        if (b == 10) {
            this.flushBuffer();
        }
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > buf.length) {
            throw new IndexOutOfBoundsException();
        }
        while (len > 0) {
            int i = this.findNewlineIndex(buf, off, len);
            if (i == off + len) {
                this.buffer.write(buf, off, len);
                off += len;
                len = 0;
                continue;
            }
            int n = i - off + 1;
            this.buffer.write(buf, off, n);
            this.flushBuffer();
            off += n;
            len -= n;
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        try {
            this.flushBuffer();
            this.out.close();
        }
        finally {
            this.buffer = null;
            this.out = null;
        }
    }

    private void flushBuffer() throws IOException {
        this.buffer.writeTo(this.out);
        this.buffer.reset();
    }

    private int findNewlineIndex(byte[] buf, int off, int len) {
        while (len > 0 && buf[off] != 10) {
            ++off;
            --len;
        }
        return off;
    }
}

