/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.TextureAttributes;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.utils.scenegraph.io.retained.Controller;
import org.jogamp.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.NodeComponentState;
import org.jogamp.vecmath.Color4f;
import org.jogamp.vecmath.Matrix4d;

public class TextureAttributesState
extends NodeComponentState {
    private static final int MAX_COLOR_OPERANDS = 2;

    public TextureAttributesState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        TextureAttributes attr = (TextureAttributes)this.node;
        Color4f clr = new Color4f();
        Matrix4d mat = new Matrix4d();
        Transform3D trans = new Transform3D();
        int tableComponents = attr.getNumTextureColorTableComponents();
        int tableSize = attr.getTextureColorTableSize();
        int[][] colorTable = new int[tableComponents][tableSize];
        out.writeInt(attr.getPerspectiveCorrectionMode());
        attr.getTextureBlendColor(clr);
        this.control.writeColor4f(out, clr);
        out.writeInt(tableComponents);
        out.writeInt(tableSize);
        attr.getTextureColorTable(colorTable);
        int i = 0;
        while (i < tableComponents) {
            int j = 0;
            while (j < tableSize) {
                out.writeInt(colorTable[i][j]);
                ++j;
            }
            ++i;
        }
        out.writeInt(attr.getTextureMode());
        attr.getTextureTransform(trans);
        trans.get(mat);
        this.control.writeMatrix4d(out, mat);
        out.writeInt(attr.getCombineRgbMode());
        out.writeInt(attr.getCombineAlphaMode());
        i = 0;
        while (i < 2) {
            out.writeInt(attr.getCombineRgbSource(i));
            out.writeInt(attr.getCombineAlphaSource(i));
            out.writeInt(attr.getCombineRgbFunction(i));
            out.writeInt(attr.getCombineAlphaFunction(i));
            ++i;
        }
        out.writeInt(attr.getCombineRgbScale());
        out.writeInt(attr.getCombineAlphaScale());
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        TextureAttributes attr = (TextureAttributes)this.node;
        attr.setPerspectiveCorrectionMode(in.readInt());
        attr.setTextureBlendColor(this.control.readColor4f(in));
        int tableComponents = in.readInt();
        int tableSize = in.readInt();
        int[][] colorTable = new int[tableComponents][tableSize];
        int i = 0;
        while (i < tableComponents) {
            int j = 0;
            while (j < tableSize) {
                colorTable[i][j] = in.readInt();
                ++j;
            }
            ++i;
        }
        if (tableComponents != 0) {
            attr.setTextureColorTable(colorTable);
        }
        attr.setTextureMode(in.readInt());
        Matrix4d mat = this.control.readMatrix4d(in);
        Transform3D trans = new Transform3D(mat);
        attr.setTextureTransform(trans);
        attr.setCombineRgbMode(in.readInt());
        attr.setCombineAlphaMode(in.readInt());
        int i2 = 0;
        while (i2 < 2) {
            attr.setCombineRgbSource(i2, in.readInt());
            attr.setCombineAlphaSource(i2, in.readInt());
            attr.setCombineRgbFunction(i2, in.readInt());
            attr.setCombineAlphaFunction(i2, in.readInt());
            ++i2;
        }
        attr.setCombineRgbScale(in.readInt());
        attr.setCombineAlphaScale(in.readInt());
    }

    @Override
    protected SceneGraphObject createNode() {
        return new TextureAttributes();
    }
}

