/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jogamp.java3d.BoundingLeaf;
import org.jogamp.java3d.Fog;
import org.jogamp.java3d.Group;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.utils.scenegraph.io.retained.Controller;
import org.jogamp.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.SceneGraphObjectState;
import org.jogamp.vecmath.Color3f;

public abstract class FogState
extends SceneGraphObjectState {
    protected int[] scopes;
    protected int boundingLeaf;

    public FogState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        this.control.writeBounds(out, ((Fog)this.node).getInfluencingBounds());
        out.writeInt(((Fog)this.node).numScopes());
        int i = 0;
        while (i < ((Fog)this.node).numScopes()) {
            out.writeInt(this.control.getSymbolTable().addReference((SceneGraphObject)((Fog)this.node).getScope(i)));
            ++i;
        }
        out.writeInt(this.control.getSymbolTable().addReference((SceneGraphObject)((Fog)this.node).getInfluencingBoundingLeaf()));
        Color3f clr = new Color3f();
        ((Fog)this.node).getColor(clr);
        this.control.writeColor3f(out, clr);
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        ((Fog)this.node).setInfluencingBounds(this.control.readBounds(in));
        this.scopes = new int[in.readInt()];
        int i = 0;
        while (i < this.scopes.length) {
            this.scopes[i] = in.readInt();
            ++i;
        }
        this.boundingLeaf = in.readInt();
        ((Fog)this.node).setColor(this.control.readColor3f(in));
    }

    @Override
    public void buildGraph() {
        int i = 0;
        while (i < this.scopes.length) {
            ((Fog)this.node).addScope((Group)this.control.getSymbolTable().getJ3dNode(this.scopes[i]));
            ++i;
        }
        ((Fog)this.node).setInfluencingBoundingLeaf((BoundingLeaf)this.control.getSymbolTable().getJ3dNode(this.boundingLeaf));
        super.buildGraph();
    }
}

