/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jogamp.java3d.ConeSound;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.utils.scenegraph.io.retained.Controller;
import org.jogamp.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.PointSoundState;
import org.jogamp.vecmath.Vector3f;

public class ConeSoundState
extends PointSoundState {
    public ConeSoundState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        float[] distanceAtten = new float[((ConeSound)this.node).getAngularAttenuationLength()];
        float[] gainAtten = new float[distanceAtten.length];
        float[] filterAtten = new float[distanceAtten.length];
        float[] backDistance = new float[distanceAtten.length];
        float[] backGain = new float[distanceAtten.length];
        float[] frontDistance = new float[distanceAtten.length];
        float[] frontGain = new float[distanceAtten.length];
        ((ConeSound)this.node).getDistanceGain(frontDistance, frontGain, backDistance, backGain);
        ((ConeSound)this.node).getAngularAttenuation(distanceAtten, gainAtten, filterAtten);
        out.writeInt(distanceAtten.length);
        int i = 0;
        while (i < distanceAtten.length) {
            out.writeFloat(distanceAtten[i]);
            out.writeFloat(gainAtten[i]);
            out.writeFloat(filterAtten[i]);
            out.writeFloat(backDistance[i]);
            out.writeFloat(backGain[i]);
            ++i;
        }
        Vector3f direction = new Vector3f();
        ((ConeSound)this.node).getDirection(direction);
        this.control.writeVector3f(out, direction);
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        float[] distanceAtten = new float[in.readInt()];
        float[] gainAtten = new float[distanceAtten.length];
        float[] filterAtten = new float[distanceAtten.length];
        float[] backDistance = new float[distanceAtten.length];
        float[] backGain = new float[distanceAtten.length];
        int i = 0;
        while (i < distanceAtten.length) {
            distanceAtten[i] = in.readFloat();
            gainAtten[i] = in.readFloat();
            filterAtten[i] = in.readFloat();
            backDistance[i] = in.readFloat();
            backGain[i] = in.readFloat();
            ++i;
        }
        ((ConeSound)this.node).setBackDistanceGain(backDistance, backGain);
        ((ConeSound)this.node).setAngularAttenuation(distanceAtten, gainAtten, filterAtten);
        ((ConeSound)this.node).setDirection(this.control.readVector3f(in));
    }

    @Override
    protected SceneGraphObject createNode() {
        return new ConeSound();
    }
}

