/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.geometry;

import java.util.ArrayList;
import org.jogamp.java3d.utils.geometry.Edge;
import org.jogamp.java3d.utils.geometry.EdgeTable;
import org.jogamp.java3d.utils.geometry.GeometryInfo;
import org.jogamp.java3d.utils.geometry.Triangulator;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Tuple3f;
import org.jogamp.vecmath.Vector3f;

public class NormalGenerator {
    private double creaseAngle;
    private ArrayList<ArrayList<Integer>> tally;
    private int[] coordInds;
    private int[] normalInds;
    private int[] colorInds;
    private int[][] texInds;
    private int[] stripCounts;
    private static long t1 = 0L;
    private static long t2 = 0L;
    private static long t3 = 0L;
    private static long t4 = 0L;
    private static long t5 = 0L;
    private static long t6 = 0L;
    private Triangulator tr = null;
    private int numTexSets;
    private static final int DEBUG = 0;

    private Vector3f[] calculatefacetNorms(GeometryInfo gi) {
        Point3f[] coordinates = gi.getCoordinates();
        Vector3f[] facetNorms = new Vector3f[this.coordInds.length / 3];
        Vector3f a = new Vector3f();
        Vector3f b = new Vector3f();
        if (gi.getOldPrim() != 2) {
            int t = 0;
            while (t < this.coordInds.length) {
                a.sub((Tuple3f)coordinates[this.coordInds[t + 2]], (Tuple3f)coordinates[this.coordInds[t + 1]]);
                b.sub((Tuple3f)coordinates[this.coordInds[t + 0]], (Tuple3f)coordinates[this.coordInds[t + 1]]);
                facetNorms[t / 3] = new Vector3f();
                facetNorms[t / 3].cross(a, b);
                facetNorms[t / 3].normalize();
                if (Float.isNaN(facetNorms[t / 3].x)) {
                    facetNorms[t / 3].x = 1.0f;
                    facetNorms[t / 3].z = 0.0f;
                    facetNorms[t / 3].y = 0.0f;
                }
                t += 3;
            }
        } else {
            int t = 0;
            while (t < this.coordInds.length) {
                a.sub((Tuple3f)coordinates[this.coordInds[t + 2]], (Tuple3f)coordinates[this.coordInds[t + 0]]);
                b.sub((Tuple3f)coordinates[this.coordInds[t + 5]], (Tuple3f)coordinates[this.coordInds[t + 1]]);
                facetNorms[t / 3] = new Vector3f();
                facetNorms[t / 3].cross(a, b);
                facetNorms[t / 3].normalize();
                if (Float.isNaN(facetNorms[t / 3].x)) {
                    facetNorms[t / 3].x = 1.0f;
                    facetNorms[t / 3].z = 0.0f;
                    facetNorms[t / 3].y = 0.0f;
                }
                facetNorms[t / 3 + 1] = new Vector3f(facetNorms[t / 3]);
                t += 6;
            }
        }
        return facetNorms;
    }

    private int createHardEdges(Vector3f[] facetNorms) {
        EdgeTable et = new EdgeTable(this.coordInds);
        this.tally = new ArrayList();
        int[] normalMap = new int[this.coordInds.length];
        int maxShare = 1;
        float threshold = (float)Math.cos(this.creaseAngle);
        int c = 0;
        while (c < this.coordInds.length) {
            normalMap[c] = Integer.MAX_VALUE;
            ++c;
        }
        c = 0;
        while (c < this.coordInds.length) {
            if (normalMap[c] == Integer.MAX_VALUE) {
                boolean smooth;
                ArrayList<Integer> sharers = new ArrayList<Integer>();
                this.tally.add(sharers);
                sharers.add(new Integer(c));
                normalMap[c] = this.tally.size() - 1;
                boolean goingRight = true;
                Edge edge = new Edge(this.coordInds[c], this.coordInds[(c + 1) % 3 == 0 ? c - 2 : c + 1]);
                int endVertex = this.coordInds[c % 3 == 0 ? c + 2 : c - 1];
                int cur = c;
                do {
                    Integer tableVal;
                    if ((tableVal = et.get(edge.v2, edge.v1)) == null) {
                        smooth = false;
                    } else {
                        int n = tableVal;
                        float cosine = facetNorms[cur / 3].dot(facetNorms[n / 3]);
                        boolean bl = smooth = cosine > threshold;
                        if (smooth) {
                            int centerv;
                            int n2 = centerv = (n + 1) % 3 == 0 ? n - 2 : n + 1;
                            if (this.coordInds[c] != this.coordInds[centerv]) {
                                int n3 = centerv = n % 3 == 0 ? n + 2 : n - 1;
                            }
                            if (normalMap[centerv] != Integer.MAX_VALUE) {
                                smooth = false;
                            } else {
                                normalMap[centerv] = this.tally.size() - 1;
                                sharers.add(new Integer(centerv));
                                if (sharers.size() > maxShare) {
                                    maxShare = sharers.size();
                                }
                                cur = n;
                                if (goingRight) {
                                    edge.v2 = this.coordInds[cur];
                                } else {
                                    edge.v1 = this.coordInds[cur];
                                }
                            }
                        }
                    }
                    if (smooth || !goingRight) continue;
                    goingRight = false;
                    smooth = true;
                    cur = c;
                    edge = new Edge(this.coordInds[c % 3 == 0 ? c + 2 : c - 1], this.coordInds[c]);
                } while (smooth && (goingRight && edge.v2 != endVertex || !goingRight));
            }
            ++c;
        }
        return maxShare;
    }

    private void calculateVertexNormals(GeometryInfo gi, Vector3f[] facetNorms, int maxShare) {
        Vector3f[] normals;
        if (this.creaseAngle != 0.0) {
            Vector3f[] fn = new Vector3f[maxShare];
            normals = new Vector3f[this.tally.size()];
            this.normalInds = new int[this.coordInds.length];
            int n = 0;
            while (n < this.tally.size()) {
                ArrayList<Integer> sharers = this.tally.get(n);
                int fnsize = 0;
                normals[n] = new Vector3f();
                int t = 0;
                while (t < sharers.size()) {
                    int v = sharers.get(t);
                    if (v != -1) {
                        int triangle = v / 3;
                        if (!Float.isNaN(facetNorms[triangle].x)) {
                            int f = 0;
                            while (f < fnsize) {
                                if (fn[f].equals((Tuple3f)facetNorms[triangle])) break;
                                ++f;
                            }
                            this.normalInds[v] = n;
                            if (f == fnsize) {
                                normals[n].add((Tuple3f)facetNorms[triangle]);
                                fn[fnsize++] = facetNorms[triangle];
                            }
                        }
                    }
                    ++t;
                }
                normals[n].normalize();
                if (Float.isNaN(normals[n].x)) {
                    normals[n].x = 1.0f;
                    normals[n].z = 0.0f;
                    normals[n].y = 0.0f;
                }
                ++n;
            }
        } else {
            normals = facetNorms;
            this.normalInds = new int[facetNorms.length * 3];
            int i = 0;
            while (i < facetNorms.length) {
                this.normalInds[i * 3 + 0] = i;
                this.normalInds[i * 3 + 1] = i;
                this.normalInds[i * 3 + 2] = i;
                ++i;
            }
        }
        gi.setNormals(normals);
    }

    private int[] triToQuadIndices(int[] oldList) {
        if (oldList == null) {
            return null;
        }
        int[] newList = new int[oldList.length / 6 * 4];
        int q = 0;
        while (q < oldList.length / 6) {
            newList[q * 4 + 0] = oldList[q * 6 + 0];
            newList[q * 4 + 1] = oldList[q * 6 + 1];
            newList[q * 4 + 2] = oldList[q * 6 + 2];
            newList[q * 4 + 3] = oldList[q * 6 + 5];
            ++q;
        }
        return newList;
    }

    private void convertTriToQuad(GeometryInfo geom) {
        geom.setCoordinateIndices(this.triToQuadIndices(geom.getCoordinateIndices()));
        geom.setColorIndices(this.triToQuadIndices(geom.getColorIndices()));
        geom.setNormalIndices(this.triToQuadIndices(geom.getNormalIndices()));
        int num = geom.getTexCoordSetCount();
        int i = 0;
        while (i < num) {
            geom.setTextureCoordinateIndices(i, this.triToQuadIndices(geom.getTextureCoordinateIndices(i)));
            ++i;
        }
        geom.setPrimitive(2);
    }

    private int[] triToFanIndices(int[] sc, int[] oldList, int numVerts) {
        if (oldList == null) {
            return null;
        }
        int[] newList = new int[numVerts];
        int vert1 = 0;
        int n = 0;
        int f = 0;
        while (f < sc.length) {
            newList[n++] = oldList[vert1++];
            newList[n++] = oldList[vert1++];
            newList[n++] = oldList[vert1++];
            int t = 3;
            while (t < sc[f]) {
                newList[n++] = oldList[vert1 + 2];
                vert1 += 3;
                ++t;
            }
            ++f;
        }
        return newList;
    }

    private void convertTriToFan(GeometryInfo geom, int[] oldStripCounts) {
        int[] ni = geom.getNormalIndices();
        int tri = 0;
        ArrayList<Integer> newStripCounts = new ArrayList<Integer>(oldStripCounts.length + 100);
        int f = 0;
        while (f < oldStripCounts.length) {
            int stripCount = 3;
            int t = 0;
            while (t < oldStripCounts[f] - 3) {
                if (ni[tri * 3] == ni[(tri + 1) * 3] && ni[tri * 3 + 2] == ni[(tri + 1) * 3 + 1]) {
                    ++stripCount;
                } else {
                    newStripCounts.add(new Integer(stripCount));
                    stripCount = 3;
                }
                ++tri;
                ++t;
            }
            ++tri;
            newStripCounts.add(new Integer(stripCount));
            ++f;
        }
        int[] sc = new int[newStripCounts.size()];
        int i = 0;
        while (i < sc.length) {
            sc[i] = (Integer)newStripCounts.get(i);
            ++i;
        }
        newStripCounts = null;
        int c = 0;
        int i2 = 0;
        while (i2 < sc.length) {
            c += sc[i2];
            ++i2;
        }
        geom.setCoordinateIndices(this.triToFanIndices(sc, geom.getCoordinateIndices(), c));
        geom.setColorIndices(this.triToFanIndices(sc, geom.getColorIndices(), c));
        geom.setNormalIndices(this.triToFanIndices(sc, geom.getNormalIndices(), c));
        int num = geom.getTexCoordSetCount();
        int i3 = 0;
        while (i3 < num) {
            geom.setTextureCoordinateIndices(i3, this.triToFanIndices(sc, geom.getTextureCoordinateIndices(i3), c));
            ++i3;
        }
        geom.setStripCounts(sc);
        geom.setPrimitive(3);
    }

    private int[] triToStripIndices(int[] sc, int[] oldList, int numVerts) {
        if (oldList == null) {
            return null;
        }
        int[] newList = new int[numVerts];
        int vert1 = 0;
        int n = 0;
        int f = 0;
        while (f < sc.length) {
            newList[n++] = oldList[vert1++];
            newList[n++] = oldList[vert1++];
            newList[n++] = oldList[vert1++];
            int t = 3;
            while (t < sc[f]) {
                newList[n++] = oldList[vert1 + 2 - t % 2];
                vert1 += 3;
                ++t;
            }
            ++f;
        }
        return newList;
    }

    private void convertTriToStrip(GeometryInfo geom, int[] oldStripCounts) {
        int[] ni = geom.getNormalIndices();
        int tri = 0;
        ArrayList<Integer> newStripCounts = new ArrayList<Integer>(oldStripCounts.length + 100);
        int f = 0;
        while (f < oldStripCounts.length) {
            int stripCount = 3;
            int t = 0;
            while (t < oldStripCounts[f] - 3) {
                if (t % 2 == 0) {
                    if (ni[tri * 3 + 1] == ni[(tri + 1) * 3] && ni[tri * 3 + 2] == ni[(tri + 1) * 3 + 2]) {
                        ++stripCount;
                    } else {
                        newStripCounts.add(new Integer(stripCount));
                        stripCount = 3;
                        if (t < oldStripCounts[f] - 4) {
                            newStripCounts.add(new Integer(3));
                            ++t;
                        }
                    }
                } else if (ni[tri * 3 + 1] == ni[(tri + 1) * 3 + 1] && ni[tri * 3 + 2] == ni[(tri + 1) * 3]) {
                    ++stripCount;
                } else {
                    newStripCounts.add(new Integer(stripCount));
                    stripCount = 3;
                }
                ++tri;
                ++t;
            }
            ++tri;
            newStripCounts.add(new Integer(stripCount));
            ++f;
        }
        int[] sc = new int[newStripCounts.size()];
        int i = 0;
        while (i < sc.length) {
            sc[i] = (Integer)newStripCounts.get(i);
            ++i;
        }
        newStripCounts = null;
        int c = 0;
        int i2 = 0;
        while (i2 < sc.length) {
            c += sc[i2];
            ++i2;
        }
        geom.setCoordinateIndices(this.triToStripIndices(sc, geom.getCoordinateIndices(), c));
        geom.setColorIndices(this.triToStripIndices(sc, geom.getColorIndices(), c));
        geom.setNormalIndices(this.triToStripIndices(sc, geom.getNormalIndices(), c));
        int num = geom.getTexCoordSetCount();
        int i3 = 0;
        while (i3 < num) {
            geom.setTextureCoordinateIndices(i3, this.triToStripIndices(sc, geom.getTextureCoordinateIndices(i3), c));
            ++i3;
        }
        geom.setStripCounts(sc);
        geom.setPrimitive(4);
    }

    void convertBackToOldPrim(GeometryInfo geom, int oldPrim, int[] oldStripCounts) {
        if (oldPrim == 1) {
            return;
        }
        switch (oldPrim) {
            case 2: {
                this.convertTriToQuad(geom);
                break;
            }
            case 3: {
                this.convertTriToFan(geom, oldStripCounts);
                break;
            }
            case 4: {
                this.convertTriToStrip(geom, oldStripCounts);
            }
        }
    }

    public void generateNormals(GeometryInfo gi) {
        gi.setNormals((Vector3f[])null);
        gi.setNormalIndices(null);
        long time = 0L;
        if (gi.getPrimitive() == 5) {
            if (this.tr == null) {
                this.tr = new Triangulator();
            }
            this.tr.triangulate(gi);
        } else {
            gi.rememberOldPrim();
            gi.convertToIndexedTriangles();
        }
        this.coordInds = gi.getCoordinateIndices();
        this.colorInds = gi.getColorIndices();
        this.normalInds = gi.getNormalIndices();
        this.numTexSets = gi.getTexCoordSetCount();
        this.texInds = new int[this.numTexSets][];
        int i = 0;
        while (i < this.numTexSets) {
            this.texInds[i] = gi.getTextureCoordinateIndices(i);
            ++i;
        }
        this.stripCounts = gi.getStripCounts();
        Vector3f[] facetNorms = this.calculatefacetNorms(gi);
        int maxShare = this.createHardEdges(facetNorms);
        this.calculateVertexNormals(gi, facetNorms, maxShare);
        gi.setCoordinateIndices(this.coordInds);
        gi.setColorIndices(this.colorInds);
        gi.setNormalIndices(this.normalInds);
        int i2 = 0;
        while (i2 < this.numTexSets) {
            gi.setTextureCoordinateIndices(i2, this.texInds[i2]);
            ++i2;
        }
        gi.setStripCounts(this.stripCounts);
    }

    public void setCreaseAngle(double radians) {
        if (radians > Math.PI) {
            radians = Math.PI;
        }
        if (radians < 0.0) {
            radians = 0.0;
        }
        this.creaseAngle = radians;
    }

    public double getCreaseAngle() {
        return this.creaseAngle;
    }

    public NormalGenerator(double radians) {
        this.creaseAngle = radians;
    }

    public NormalGenerator() {
        this(0.767944870877505);
    }
}

